/*************************************************************
 * File: lib/striequ.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include "string.h"

/*************************************************************
*  int striequ(s1,s2) 
*	returns 1 if s1 matches s2 ignoring case, else 0 
*/
int striequ(s1,s2)
char *s1,*s2;
{

if (!s1 || !s2) return(0);
for (;*s1;s1++,s2++) {
	if (toupper(*s1) != toupper(*s2)) return(0);
	}
if (*s2) return(0);
return(1);
}

#if 0 /*HTML*/
$NAME=striequ;
$SYNOPSIS= <<EOF;
#include <string.h>
int striequ(char *s1, char *s2)
EOF
$DESCRIPTION= <<EOF;
striequ() compares  its  arguments  and  returns  an  integer equal to
one or 0, depending whether s1 is equal to, or not equal to s2. The
case of the characters is ignored during the comparison.
EOF
$SEEALSO="strcmp strequ strncmp";
$CATAGORY=string;
#endif
