/*************************************************************
 * File: lib/strcpy.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <regdef.h>

/* Note that the Algorithmics assembler generates 2 warnings for this
 * file.  This is because the assembler considers the load instructions
 * are not save in the delay slot of a branch.  You can safely ignore 
 * the warnings.  
 */

#ifndef CYGNUS

/*
** strcpy(dst,src)
**    Copy source string to destination.
**    Neither the source nor destination need be word aligned.
*/

        .globl strcpy
        .ent strcpy
strcpy: # a0=dst a1=src
        # byte lengths in comments include terminating null
        move    v0,a0

        .set noreorder
1:    	lb      t0,0(a1)
        ulw     t4,(a1)
        beq     t0,zero,one
         lb     t1,1(a1)
        usw     t4,(a0)
        beq     t1,zero,two
	 nop
        lb      t2,2(a1)
        addu    a1,4
        beq     t2,zero,three
         lb     t3,-1(a1)
        addu    a0,4
        bne     t3,zero,1b
         nop
        j       ra
	 nop

three:  sb      t2,2(a0)
two:    sb      t1,1(a0)
one:    sb      t0,(a0)
        j       ra
	 nop
        .end strcpy
#endif
