/*************************************************************
 * File: lib/sbrk.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#define NULL 0
#define ALLOCSIZE 128*1024


char allocbuf[ALLOCSIZE];
char *allocp1 = allocbuf;

/*************************************************************
*  sbrk() is alloc() on page 101 of K & R  Edition 2
*	This sbrk is used by PMON, the sbrk in crt1.s is used
*	by clients.
*/
char *sbrk(n)
int n;
{

	if (allocp1 + n <= allocbuf + ALLOCSIZE) {
		allocp1 += n;
		return(allocp1 - n);
	} else
		return(NULL);
}

