/*************************************************************
 * File: lib/rstrstr.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	980224	Created
 */

#include "string.h"

/*************************************************************
*  char *rstrstr(p,q) 
*	returns a ptr to q in p, else 0 if not found. Unlike
*	strstr(), this function performs a reverse search, ie. it
*	starts at the end of the string.
*/
char *rstrstr(p,q)
char *p,*q;
{
int qlen,plen;
char *r,*s,*t;

qlen = strlen(q);
plen = strlen(p);
if (plen < qlen) return(0);

r = &p[plen-1];
for (;r>=p;r--) {
	if (*r == *q) {
		t = r; s = q;
		for (;*t;s++,t++) {
			if (*t != *s) break;
			}
		if (! *s) return(r);
		}
	}
return(0);
}

