/*************************************************************
 * File: lib/queue.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include "queue.h"

/*************************************************************
*  These queue manipulation routines are used by PMON
*/

#ifdef TEST
/*************************************************************
*  main() 
*	This is a simple test program for the queue routines
*/
main() 
{
char buf[20];
int size,msg;
Queue *p;

printf("Enter Queue size >");
gets(buf);
sscanf(buf,"%d",&size);
p = Qcreate(size);

for (;;) {
	printf("inp=%d outp=%d\n",p->inp,p->outp);
	printf("Qfull=%d Qempty=%d Qsize=%d\n",Qfull(p),Qempty(p),Qinquiry(p));
	printf("g or p >");
	gets(buf);
	if (buf[0] == 'g') {
		msg = (int)Qget(p);
		printf("msg=%d\n",msg);
		}
	else if (buf[0] == 'p') {
		sscanf(buf,"p %d",&msg);
		Qput(p,(Msg) msg);
		}
	}
}

reschedule(){}
#endif

/*************************************************************
*  Queue *Qcreate(size) creates a queue of specified size
*/
Queue *Qcreate(size)
int size;
{
int max;
Queue *q;

max = size + 1;
q = (Queue *)malloc(sizeof(Queue)+(max*sizeof(Msg)));
if (!q) return(0);
q->max = size;
q->inp = 0;
q->outp = 0;
return(q);
}

/*************************************************************
*  Qput(q,msg) adds msg to queue
*/
Qput(q,msg)
Queue *q;
Msg msg;
{
Msg *dat;

while (Qfull(q)) reschedule();

dat = (Msg *) (((int)q) + sizeof(Queue));
dat[q->inp] = msg;
q->inp++;
if (q->inp > q->max) q->inp = 0;
}

/*************************************************************
*  Msg Qget(q) removes a msg from a queue
*/
Msg Qget(q)
Queue *q;
{
Msg msg,*dat;

while (Qempty(q)) reschedule();

dat = (Msg *) (((int)q) + sizeof(Queue));
msg = dat[q->outp];
q->outp++;
if (q->outp > q->max) q->outp = 0;
return(msg);
}

/** Qfull(q) returns 1 if queue is full (macro) */
/** Qempty(q) returns 1 if queue is empty (macro) */

/*************************************************************
*  Qinquiry(q,op) inquire about queue SIZE, USED, SPACE
*/
Qinquiry(q,op)
Queue *q;
int op;
{
int i,r;

r = 0;
switch (op) {
	case Q_SIZE : /* what's the capacity of the queue? */
		r = q->max - 1;
		break;
	case Q_USED : /* how much space is used? */
		i = q->inp;
		if (i < q->outp) i += q->max + 1;
		r = i - q->outp;
		break;
	case Q_SPACE : /* how much space is left? */
		i = q->inp;
		if (i < q->outp) i += q->max + 1;
		r = (q->max - 1) - (i - q->outp);
		break;
	default :
		r = -1;
	}
return(r);
}

/*************************************************************
*  Msg Qread(q,n) read msg n from queue (non destructive)
*/
Msg Qread(q,n)
Queue *q;
int n;
{
int i;
Msg *dat;

i = q->outp;
for (;n>0;n--) {
	if (i == q->inp) return(0);
	i++;
	if (i > q->max) i = 0;
	}
dat = (Msg *) (((int)q) + sizeof(Queue));
return(dat[i]);
}

