/*************************************************************
 * File: lib/p8530.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

/* 
 * polled I/O routines for the 8530 SCC 
 *
 * Warning: These routines are untested. If you do use this module
 * successfully, I would appreciate knowing about any changes that
 * were necessary.
 */
#include "terms.h"

#define RXRDY 0x01
#define TXRDY 0x04
#define RXENB 0x01
#define TXENB 0x08
#define DELAY 30

#define rdsr(x,y)	(rdmem(x+((y)?0:8)))
#define rdrhr(x,y)	(rdmem(x+((y)?0:8)+4))
#define wrthr(x,y,z)	(wrmem(x+((y)?0:8)+4,z))
#define rdmem(a)	(*a)

typedef struct Inittab {
	int reg;
	int value;
	} Inittab;

static Inittab inittab[] = {
	{9, 0xc0},	/* master int cntrl*/
	{14,0x02},	/* misc cntrl bits*/
	{3, 0xc0},		/* rx cntrl parameters*/
	{5, 0xe2},		/* tx cntrl parameters*/
	{10,0x00},		/* misc rx & tx cntrls*/
	{4, 0x44},		/* misc rx & tx cntrls*/
	{11,0x50},		/* clock mode*/
	{12,0x0e},		/* upper byte of baudrate = 9600*/
	{13,0x00},		/* lower byte of baudrate*/
	{14,0x03},		/* misc cntrl bits*/
	{3, 0xc1},		/* rx cntrl parameters*/
	{5, 0xea},		/* tx cntrl parameters*/
	{255}};

static Ushort btab[] = {
	/* if 0 baud rate not supported*/
	0,	/* B0*/
	39934,	/* B50*/
	26622,	/* B75*/
	18151,	/* B110*/
	14844,	/* B134*/
	13310,	/* B150*/
	9982,	/* B200*/
	6654,	/* B300*/
	3326,	/* B600*/
	1662,	/* B1200*/
	1107,	/* B1800*/
	830,	/* B2400*/
	414,	/* B4800*/
	206,	/* B9600*/
	102,	/* B19200*/
	50	/* B38400*/
	};

p8530(op,siodat,chan,ch)
int op,chan,ch;
struct p8530info *siodat;
{
int i,cha;

switch (op) {
	case OP_RXRDY :
		if (rdsr(siodat->siobase,chan) & RXRDY) return(1);
		break;
	case OP_RX :
		return(rdrhr(siodat->siobase,chan));
		break;
	case OP_TXRDY :
		if (rdsr(siodat->siobase,chan) & TXRDY) return(1);
		break;
	case OP_TX :
		wrthr(siodat->siobase,chan,ch);
		break;
	case OP_INIT :
		cha = 0;
		for (i=0;inittab[i].reg != 255;i++) {
			wreg(siodat->siobase,cha,inittab[i].reg,
				inittab[i].value);
			if (inittab[i].reg == 3) 
				siodat->wr3[cha] = inittab[i].value;
			if (inittab[i].reg == 5) 
				siodat->wr5[cha] = inittab[i].value;
			}
		cha = 1;
		for (i=0;inittab[i].reg != 255;i++) {
			wreg(siodat->siobase,cha,inittab[i].reg,
				inittab[i].value);
			if (inittab[i].reg == 3) 
				siodat->wr3[cha] = inittab[i].value;
			if (inittab[i].reg == 5) 
				siodat->wr5[cha] = inittab[i].value;
			}
		break;
	case OP_BAUD :
		if (ch > 15) return(1);
		if (btab[ch] == 0) return(1);
		wreg(siodat->siobase,chan,3,siodat->wr3[chan]&~RXENB);
		wreg(siodat->siobase,chan,5,siodat->wr5[chan]&~TXENB);
		wreg(siodat->siobase,chan,12,btab[ch]&0xff);
		wreg(siodat->siobase,chan,13,btab[ch]>>8);
		wreg(siodat->siobase,chan,3,siodat->wr3[chan]);
		wreg(siodat->siobase,chan,5,siodat->wr5[chan]);
		break;
	}
return(0); /* successful return */
}

wreg(base,chan,reg,value)
byte *base;
int chan,reg,value;
{
if (chan == 0) chan = 8;
else chan = 0;
wrmem(base+chan,reg);
wrmem(base+chan+4,value);
}

wrmem(addr,value)
byte *addr;
int value;
{
int i;

*addr = value;
wbflush();
for (i=0;i<DELAY;i++) ;
}

