/*************************************************************
 * File: lib/open.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <termio.h>
#include <errno.h>

extern unsigned long _filebase;

open(fname,mode)
char *fname;
int mode;
{
int fd,i;

if ((fd=_open(fname,mode)) != -1) return(fd);

if (mode != 0) { /* no writeable files yet */
	errno = EACCES;
	return(-1); 
	}

if (_mfile[0].base == 0) {
	for (i=0;_mfile[i].name;i++) _mfile[i].base += _filebase;
	}

for (i=0;_mfile[i].name;i++) {
	if (strequ(fname,_mfile[i].name)) break;
	}
if (_mfile[i].name == 0) { /* file not found */
	errno = ENOENT;
	return(-1);
	}

if (_mfile[i].open) { /* already open */
	errno = EACCES;
	return(-1);
	}

_mfile[i].open = 1;
_mfile[i].posn = 0;
return(i+FILEOFFSET);
}

