/*************************************************************
 * File: lib/lseek.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <termio.h>
#include <errno.h>
#include <unistd.h>

/*************************************************************
*  lseek(fd,offset,whence)
*/
lseek(fd,offset,whence)
int fd,whence;
long offset;
{
Ramfile *p;

if (fd < FILEOFFSET) {
	/* can't seek on tty devices */
	errno = EINVAL;
	return(-1L);
	}

fd -= FILEOFFSET;
if (_mfile[fd].open != 1) {
	errno = EBADF;
	return(-1L);
	}

p = &_mfile[fd];
switch (whence) {
	case SEEK_SET : p->posn = offset; break;
	case SEEK_CUR : p->posn += offset; break;
	case SEEK_END : p->posn = p->size + offset; break;
	default : errno = EINVAL; return(-1L);
	}
return(p->posn);
}

