/*************************************************************
 * File: lib/longjmp.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <setjmp.h>
#include <mips.h>

/** setjmp(buffer) save context */
	.globl	setjmp
	.ent setjmp
setjmp:
	sw	s0,JB_S0*4(a0)
	sw	s1,JB_S1*4(a0)
	sw	s2,JB_S2*4(a0)
	sw	s3,JB_S3*4(a0)
	sw	s4,JB_S4*4(a0)
	sw	s5,JB_S5*4(a0)
	sw	s6,JB_S6*4(a0)
	sw	s7,JB_S7*4(a0)
	sw	fp,JB_FP*4(a0)
	sw	sp,JB_SP*4(a0)
	sw	ra,JB_RA*4(a0)
	li	v0,0
	j	ra
	.end setjmp

/** longjmp(buffer,value) restore context */
	.globl	longjmp
	.ent longjmp
longjmp:
	lw	s0,JB_S0*4(a0)
	lw	s1,JB_S1*4(a0)
	lw	s2,JB_S2*4(a0)
	lw	s3,JB_S3*4(a0)
	lw	s4,JB_S4*4(a0)
	lw	s5,JB_S5*4(a0)
	lw	s6,JB_S6*4(a0)
	lw	s7,JB_S7*4(a0)
	lw	fp,JB_FP*4(a0)
	lw	ra,JB_RA*4(a0)
	lw	sp,JB_SP*4(a0)
	move	v0,a1
	jr	ra
	.end longjmp

/** _getSp() returns the current value of the stack pointer */
	.globl _getSp
	.ent _getSp
_getSp:
	move	v0,sp
	j	ra
	.end _getSp

