/*************************************************************
 * File: irqvec.c
 * Purpose: Vector table for pmIRQInstall and saIRQInstall
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	981016	Created from pmirq.c
 */

#include <utypes.h>
#include <irqvec.h>

Func *IRQVector[MAXINTHNDLRS];
Uchar pri_table[256];

/**************************************************************
* buildPriTable(addr)
* Generate table containing int number.
* Int numbers are 1 thru 8, corresponding to sw0 thru int5.
*/

void buildPriTable(Uchar *addr)
{
int value,count,n;

addr++;
value = 1;
for (count=1;count <= 128;count <<= 1) {
        for (n=count;n>0;n--) *addr++ = value;
        value++;
        }
}

