/*************************************************************
 * File: lib/iram.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	970325	Replaced Ulong typedef with include of utypes.h
 */

#ifndef LR33300
#define LR33300
#endif
#include <mips.h>
#include <utypes.h>

#define BIU_IRAM_WR     0x00034800 /*
                        DS=0 => Disable D-Cache
                        IS1=1 => Enable I-Cache Set 1
                        IBLKSZ=0 => i-cache block fill size 2 words
                        INTP=0, NOPAD=0, BGNT=1 =>
                        INT[5:0]activeLow,WaitState,EnableBusGrant
                        LDSCH=1 => Enable load scheduling
                        NOSTR=1 => Enable instruction streaming.
                        */

/*************************************************************
*  write_iram(dst,src,n)
*	copy n words into iram
*/
write_iram(dst,src,n)
Ulong *dst,*src;
int n;
{
Ulong save;

save = BIU;
BIU = BIU_IRAM_WR;	
for (;n>0;n--) write_Disolated(dst++,*src++);
BIU = save;

}

/*************************************************************
*  read_iram(dst,src,n)
*	copy n words from iram
*/
read_iram(dst,src,n)
Ulong *dst,*src;
int n;
{
Ulong save;

save = BIU;
BIU = BIU_IRAM_WR;
for (;n>0;n--) *dst++ = read_Disolated(src++);
BIU = save;
}
