/*************************************************************
 * File: lib/iceexcp.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <mips.h>

/*************************************************************
*  ice_ehandler:
*	This is the exception handler that gets copied to RAM.
*	If the application uses exceptions, it will use this
*	code to transfer control to the IceKernel for all 
*	non-application exceptions.
*/
	.globl ice_ehandler
	.globl ice_ehandler_end
	.ent ice_ehandler
ice_ehandler:
	# check for app-specific exceptions
	#
	#
	# else; transfer control to the ICEKernel
	li	k0,0xbfc00180
	j	k0
ice_ehandler_end:
	.end ice_ehandler

