/*************************************************************
 * File: lib/ic5000.c
 * Purpose: C startup file for 4101
 * Revision History:
 *	010914	Created
 */

/*
 * DEFBAUD, ETHERNET, ETHERHWADDR, ETHERIPADDR, are determined 
 * by the values in include/defines.h.
 */

#include <terms.h>
#include <termio.h>

int p16550();
static struct p16550Rec tty0dat = {M_BASE_16550,0,4,50};

vpFunc *ether_driver_ptr;
extern void *_clkinfo;
int _ehandler(),_ehandler_end();
int vflag;

struct {
	char *name;
	char *value;
	} envlist[] = {
#ifdef ETHERNET
	{"etheraddr",ETHERHWADDR},
	{"ipaddr",   ETHERIPADDR},
#endif
	{0}};

/*************************************************************
*/
void cstartup(void)
{
p = (DevEntry *) addDevice((Addr)&tty0dat,0,p16550,1024,DEFBAUD);
if (p != 0) p->fifoenabled = 1;			/* flag fifo is enabled */
#ifdef ETHERNET
#ifndef MIPSEB
 re_ether = 1;
#endif
 ether_driver_ptr = mspeth_driver;
#endif
memcpy((void *)GEN_VECT,_ehandler,((Ulong)_ehandler_end)-((Ulong)_ehandler));
flush_cache(DCACHE);
flush_cache(ICACHE);
mtc0(C0_SR,mfc0(C0_SR)&~SR_BEV);
}

/*************************************************************
*/
flush_cache(int mode) 
{ 
r5000_flush(mode); 
}

/*************************************************************
*  Stubs and pass-throughs
*/
int open(char *name,int mode){return _open(name,mode);}
int close(int fd) {return _close(fd);}
int read(int fd,char *buf,int len) {return _read(fd,buf,len);}
int write(int fd,char *buf,int len) {return _write(fd,buf,len);}


#ifndef ETHERNET
ether_open(){return(-1);} /* called by _open */
ether_close() {} /* called by _close */
ether_read() {} /* called by _read */
#endif


/***********************************************************************
*/
char *getMonEnv(char *name)
{
int i;

for (i=0;envlist[i].name;i++) {
	if (strequ(name,envlist[i].name)) return(envlist[i].value);
	}
return(0);
}

