/*************************************************************
 * File: lib/ic4102.c
 * Purpose: C startup file for 4102
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	981014	Created from c4101.c
 */

/*
 * DEFBAUD, ETHERNET, ETHERHWADDR, ETHERIPADDR, are determined 
 * by the values in include/defines.h.
 */

#include <terms.h>
#include <termio.h>

/*#undef ETHERNET	/* disable ETHERNET support */

int p16550();
static struct p16550Rec tty0dat = {0xbe000000,0,1,14};
#ifdef ETHERNET
void *am79970_driver();
#endif

Func *_clkfunc;
Func *clkinit_tmr1_4102();
extern fFunc *clkinit_ptr;
vpFunc *ether_driver_ptr;
extern void *_clkinfo;
int _ehandler(),_ehandler_end();
int vflag;

struct {
	char *name;
	char *value;
	} envlist[] = {
	{"clkfreq","100"},
#ifdef ETHERNET
	{"etheraddr",ETHERHWADDR},
	{"ipaddr",   ETHERIPADDR},
#endif
	{0}};

/*************************************************************
*/
void cstartup(void)
{
addDevice((Addr)&tty0dat,0,p16550,1024,DEFBAUD);
clkinit_ptr = clkinit_tmr1_4102;
_clkinfo = &tty0dat;
#ifdef ETHERNET
ether_driver_ptr = am79970_driver;
#endif
memcpy((void *)GEN_VECT,_ehandler,((Ulong)_ehandler_end)-((Ulong)_ehandler));
flush_cache(DCACHE);
flush_cache(ICACHE);
mtc0(C0_SR,mfc0(C0_SR)&~SR_BEV);
}

/*************************************************************
*/
flush_cache(int mode) 
{
r4001_flush(mode); 
}

/*************************************************************
*  Stubs and pass-throughs
*/
int open(char *name,int mode){return _open(name,mode);}
int close(int fd) {return _close(fd);}
int read(int fd,char *buf,int len) {return _read(fd,buf,len);}
int write(int fd,char *buf,int len) {return _write(fd,buf,len);}


#ifndef ETHERNET
ether_open(){return(-1);} /* called by _open */
ether_close() {} /* called by _close */
ether_read() {} /* called by _read */
#endif


/***********************************************************************
*/
char *getMonEnv(char *name)
{
int i;

for (i=0;envlist[i].name;i++) {
	if (strequ(name,envlist[i].name)) return(envlist[i].value);
	}
return(0);
}

