/*************************************************************
 * File: lib/ia5000.s
 * Purpose: C startup code for BDMR4101
 * Revision History:
 *	010914	Created from a4001.s
 */

#include <mips.h>

#ifdef ROM_BASED
#define _start bspstart
#endif

#ifdef R4KEXCEPTIONS
#define IRQTrap IRQTrap4k
#endif
		
/* 
 * Assembly startup code for executing a downloaded program under SerialICE.
 */

#define STACKSIZE	(8*1024)
	.comm	stack,STACKSIZE

	.globl _start
	.globl _exit
	.globl _ehandler
	.globl _ehandler_end
	.globl IRQInstall

/*************************************************************
*/
	.ent _start
_start:
        # flush both caches
	la	s0,r5000_flush
        or      s0,K1BASE
        li      a0,ICACHEI
        jal     s0
        li      a0,DCACHEI
        jal     s0

#ifdef ROM_BASED
	# This address *must* match the -D address used in the link
	li	a0,0x80000300
	jal	cpdata
#endif
	jal	clrbss

	# set the global data pointer
	la	gp,_gp

	# set sp
	la	sp,stack+STACKSIZE-24

	# call the C startup code
	la	t0,cstartup
	jal	t0

 	# call the main C routine
	la	t0,main
	jal	t0
_exit:
	break 	99
	b	_exit
	.end _start


/*************************************************************
*  _ehandler:
*	This is the exception handler that gets copied to RAM.
*	It is used to transfer control to the main exception
*	handler (IRQTrap).
*/
	.ent _ehandler
_ehandler:
#ifdef ROM_BASED
	la	k0,IRQTrap
	jr	k0
#else
	j	IRQTrap
#endif
_ehandler_end:
	.end _ehandler

/*************************************************************
*  IRQInstall:
*	This ensures that you get saIRQInstall rather than
*	pmIRQInstall.
*/
	.ent IRQInstall
IRQInstall:
	j	saIRQInstall
	.end IRQInstall

/*************************************************************
*  sbrk(size)
*	returns a pointer to a block of memory of the requested size.
*	Returns zero if heap overflow is detected. Heap overflow occurs
*	when the upper limit of the requested size, overlaps the stack
*	pointer. This assumes that the stack grows down from high
*	memory.
*/
	.globl sbrk
	.ent sbrk
sbrk:
	li	v0,0
	la	t0,allocp1
	lw	t6,(t0)

	# force word align
	addu	t6,3
	and	t6,~3

#if 0 /* overflow check */
	# check for heap overflow
	and	t1,t6,0xe0000000	# get seg
	and	t2,sp,~0xe0000000
	or	t1,t2			# heap limit
	addu	t7,t6,a0
	blt	t7,t1,1f
	j	ra
#else
	addu	t7,t6,a0
#endif

1:	# ok - pass value back to caller
	sw	t7,(t0)
	subu	v0,t7,a0
	j	ra
	.end sbrk

	.data
	.globl allocp1
#ifndef BSO_TASKING
	.word _ftext
	.word etext
#endif
allocp1: .word  BSS_END

