/*************************************************************
 * File: lib/hosttype.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	980409	Added 90084 (DCAM)
 *	980415	Current DCAM chips are 0x1102 (DCAM-101D)
 *	980616	Added 4102. PrID = 0x2f80.
 *	980629	Added code to descriminate between 64363 and 64364.
 *	980704	Added case for 64388 RAP.
 *	980719	Added case for IDT4650 0x22xx.
 *	980731	Added 4011c prid=4021
 *	980818	Added DCAM RevE prid=1103
 *	980818	Added 4011 RevD prid=4031
 *	990211	Added DCAM-111 prid=1105
 */

#include <mips.h>

/*
** Return machine type: 5000
*/

	.globl getHostType
	.ent getHostType
getHostType:
	move	t9,ra

	.set noreorder
	mfc0	t6,C0_PRID
	nop
	.set reorder
	bne t6,0x18305,0f

	# BRECIS mips 5000
	li	v0,5000
	b	done
	
0:	# unknown
	li	v0,0
	b	done

done:	move	ra,t9
	j	ra
	.end getHostType


