/*************************************************************
 * File: lib/haswhat.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	980703	Modified to keep them from clobbering t8 or t9.
 */

#ifndef LR33020
#define LR33020
#endif
#include <mips.h>

/*
** Test for presence of various bits of hardware.
**	don't use t8 or t9 in any of these routines.
*/

/*************************************************************
*  hasFPU
*	check for presence of Floating-point coprocessor (CP1)
*/
	.globl hasFPU
	.ent hasFPU
hasFPU:
	.set noreorder
	mfc0	t7,C0_SR
	nop
	or	t0,t7,SR_CU1	# enable CU1
	and	t0,~SR_IEC	# need to disable ints
	mtc0	t0,C0_SR
	nop			# give it time..
	nop			# ...
	.set reorder

	li	v0,0		# default return = not present
	ctc1	zero,$31
	li	t0,0xffffffff
	ctc1	t0,$31
	cfc1	t1,$31

	li	t0,0x0083ffff
	and	t1,t0
	bne	t1,t0,3f

	# cp1 is present
	# check to see if CpCond1 pin is connected
	bc1f	3f		# should be high

#ifdef BSO_TASKING
	.set noreorder
	ctc1	zero,$31
	nop
	nop
	nop
	bc1t	3f		# should be low
	nop
	.set reorder
#else
#ifdef EPI
	.set noreorder
	ctc1	zero,$31
	nop
	nop
	nop
	bc1t	3f		# should be low
	nop
	.set reorder
#else
	ctc1	zero,$31
	bc1t	3f		# should be low
#endif
#endif

	# all present and correct
	li	v0,1

3:	# restore SR
	.set noreorder
	mtc0	t7,C0_SR
	.set reorder

	j	ra
	.end hasFPU

/*************************************************************
*  hasCP2
*	check to see if CP2 is present
*/
	.globl hasCP2
	.ent hasCP2
hasCP2: 
	.set noreorder
	mfc0	t7,C0_SR
	nop
	li	t1,SR_CU2
	or	t0,t7,t1
	mtc0	t0,C0_SR
	nop

	nop
	mtc2	zero,C2_BLANKE
	nop
	li	t1,0x5555aaaa
	mtc2	t1,C2_BLANKE
	nop
	mfc2	t2,C2_BLANKE
	nop
	mtc0	t7,C0_SR		# restore SR
	.set reorder

	bne	t2,t1,1f
	li	v0,1
	b	2f

1:	li	v0,0
2:	j	ra
	.end hasCP2

/*************************************************************
*  has33120
*	check for presence of LR33120
*/
	.globl has33120
	.ent has33120
has33120:
	li	t1,M_CFGREG
	lw	t0,(t1)
	and	t0,~CR_XLE
	sw	t0,(t1)
	lw	t0,(t1)
	li	v0,0
	bgez	t0,1f	/* bra if '020 */
	li	v0,1    /* must be '120 */
1:	j	ra
	.end has33120
