/*************************************************************
 * File: lib/fseek.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <stdio.h>

/*************************************************************
*  fseek(fp,offset,whence)
*/
fseek(fp,offset,whence)
FILE *fp;
long offset;
int whence;
{
int n;

if (whence == 1) { /* relative seek */
	if (offset > 0 && offset <= fp->cnt) {
		fp->cnt -= offset;
		fp->ptr += offset;
		return(0);
		}
	if (offset < 0 && offset < (fp->ptr-fp->buf)) {
		fp->cnt += offset;
		fp->ptr -= offset;
		return(0);
		}
	}
fp->cnt = 0;
n = lseek(fp->fd,offset,whence);
return(n);
}

