/*************************************************************
 * File: lib/fputs.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <stdio.h>

/*************************************************************
*  fputs(string,fp) put string to stream
*/
fputs(string,fp)
char *string;
FILE *fp;
{
char *d,*dst,*p;
int n;

#ifndef PMCC
n = 0;
for (p=string;*p;p++) {
	if (*p == '\n') n++;
	n++;
	}
dst = (char *)malloc(n+2);
for (d=dst,p=string;*p;p++) {
	if (*p == '\n') *d++ = '\r';
	*d++ = *p;
	}
*d = 0;
if (write(fileno(fp),d,strlen(d)) != -1) return(0);
free(dst);
#else
if (write(fp->fd,string,strlen(string)) != -1) return(0);
#endif
return(-1);
}

