/*************************************************************
 * File: lib/filbuf.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *`	980113	Added (Uchar *) cast to malloc
 */

#include <stdio.h>
#include <malloc.h>

/*************************************************************
* _filbuf(fp)
*/
_filbuf(fp)
FILE *fp;
{
if (fp->buf == 0) {
	fp->buf = (unsigned char *)malloc(MAXLN+1); /* 980113 */
	if (fp->buf == 0) {
		fprintf(stderr,"_filbuf: malloc failed\n");
		exit(1);
		}
	}
fp->ptr = fp->buf+1;
fp->cnt = read(fp->fd,fp->buf+1,MAXLN);
if (fp->cnt == 0) {
	fp->eof = 1;
	return(EOF);
	}
return(getc(fp));
}
