/*************************************************************
 * File: lib/crt2.s
 * Purpose: Start-up code for a field-updateable rom image
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970605	Created
 *	971001	Added NO_SERVICES
 *	971001	Changed exit code
 *	980507	Changed NO_SERVICES to TOS
 *	981030	Moved from xflash/crt0.s
 */

#include <mips.h>

#define TBLBASE 0xbfc00500
#define DVRIF_VERS 2

#ifdef TOS
#define TBLENTRY(n,m) 			\
	.globl m; 			\
	.ent m;				\
m:	j	ra;			\
	.end m
#else
#define TBLENTRY(n,m) 			\
	.globl m; 			\
	.ent m;				\
m:	li	t0,TBLBASE+(4*n);	\
	lw	t0,(t0);		\
	j	t0;			\
	.end m
#endif

	# this table must be in the text section
	.globl dvrtbl
dvrtbl:
	.set noreorder
	j	_start
	nop
	.set reorder
	.word	DVRIF_VERS
	.word	0
	.word	_drivername
	.word	0
	.word	0
	.word	0
	.word	0
	.word	0
	.word	0
	.word	0
	.word	0

	.globl _exit
	.globl _start
	.ent _start
_start:
#ifdef TOS
	li	sp,TOS
#endif
	subu	sp,24
	sw	ra,20(sp)
	jal 	clrbss

	# set the global data pointer
	la	gp,_gp

	jal	main
_exit:
#ifdef TOS
   	break	0
	# exit code is in reg a0, see xflash.c.
#else
	li	t0,TBLBASE+(4*8)
	lw	t0,(t0)
	j	t0
#endif
	.end _start



TBLENTRY(0,read)
TBLENTRY(1,write)
TBLENTRY(2,open)
TBLENTRY(3,close)
TBLENTRY(4,ioctl)
TBLENTRY(5,printf)
TBLENTRY(11,flush_cache)

#ifdef TOS
/*************************************************************
*  sbrk(size)
*	returns a pointer to a block of memory of the requested size.
*	Returns zero if heap overflow is detected. Heap overflow occurs
*	when the upper limit of the requested size, overlaps the stack
*	pointer.
*/
	.globl sbrk
	.ent sbrk
sbrk:
	li	v0,0
	la	t0,allocp1
	lw	t6,(t0)
#if 0 /* check for heap overflow against sp */
	and	t1,t6,0xe0000000	# get seg
	and	t2,sp,~0xe0000000
	or	t1,t2			# heap limit
	addu	t7,t6,a0
	blt	t7,t1,1f
	j	ra
1:	sw	t7,(t0)
#else
	addu	t7,t6,a0
	sw	t7,(t0)
#endif
	subu	v0,t7,a0
	j	ra
	.end sbrk

	.data
	.globl allocp1
#ifndef BSO_TASKING
	.word _ftext
	.word etext
#endif
allocp1: .word  BSS_END

#endif
