/*************************************************************
 * File: lib/cpsupp.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <mon.h>

int std_mtc0(), std_mfc0();

Func *mtc0_ptr = std_mtc0;
Func *mfc0_ptr = std_mfc0;

mfc0(reg)
int reg;
{
if (!mfc0_ptr) return(0);
return (* mfc0_ptr)(reg);
}

mtc0(reg,val)
int reg;
Ulong val;
{
if (!mfc0_ptr) return;
(* mtc0_ptr)(reg,val);
}


int std_mtc1(), std_mfc1();

Func *mtc1_ptr = std_mtc1;
Func *mfc1_ptr = std_mfc1;

mfc1(reg)
int reg;
{
if (!mfc1_ptr) return(0);
return (* mfc1_ptr)(reg);
}

mtc1(reg,val)
int reg;
Ulong val;
{
if (!mfc1_ptr) return;
(* mtc1_ptr)(reg,val);
}

int std_ctc1(), std_cfc1();

Func *ctc1_ptr = std_ctc1;
Func *cfc1_ptr = std_cfc1;

cfc1(reg)
int reg;
{
if (!cfc1_ptr) return(0);
return (* cfc1_ptr)(reg);
}

ctc1(reg,val)
int reg;
Ulong val;
{
if (!cfc1_ptr) return;
(* ctc1_ptr)(reg,val);
}

int std_mtc2(), std_mfc2();

Func *mtc2_ptr = std_mtc2;
Func *mfc2_ptr = std_mfc2;

mfc2(reg)
int reg;
{
if (!mfc2_ptr) return(0);
return (* mfc2_ptr)(reg);
}

mtc2(reg,val)
int reg;
Ulong val;
{
if (!mfc2_ptr) return;
(* mtc2_ptr)(reg,val);
}

int std_ctc2(), std_cfc2();

Func *ctc2_ptr = std_ctc2;
Func *cfc2_ptr = std_cfc2;

cfc2(reg)
int reg;
{
if (!cfc2_ptr) return(0);
return (* cfc2_ptr)(reg);
}

ctc2(reg,val)
int reg;
Ulong val;
{
if (!cfc2_ptr) return;
(* ctc2_ptr)(reg,val);
}

int std_mtc3(), std_mfc3();

Func *mtc3_ptr = std_mtc3;
Func *mfc3_ptr = std_mfc3;

mfc3(reg)
int reg;
{
if (!mfc3_ptr) return(0);
return (* mfc3_ptr)(reg);
}

mtc3(reg,val)
int reg;
Ulong val;
{
if (!mfc3_ptr) return;
(* mtc3_ptr)(reg,val);
}

int std_ctc3(), std_cfc3();

Func *ctc3_ptr = std_ctc3;
Func *cfc3_ptr = std_cfc3;

cfc3(reg)
int reg;
{
if (!cfc3_ptr) return(0);
return (* cfc3_ptr)(reg);
}

ctc3(reg,val)
int reg;
Ulong val;
{
if (!cfc3_ptr) return;
(* ctc3_ptr)(reg,val);
}

