/*************************************************************
 * File: lib/cp1supp.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <mips.h>

/*
** Support for coprocessor 1 (FPU)
**
**	value = cfc1(reg)
**	ctc1(value,reg)
**	value = mfc1(reg)
**	mtc1(value,reg)
*/

	.data
cfc1L:	.word cfc10, cfc11, cfc12, cfc13, cfc14, cfc15, cfc16, cfc17
	.word cfc18, cfc19, cfc110, cfc111, cfc112, cfc113, cfc114
	.word cfc115, cfc116, cfc117, cfc118, cfc119, cfc120, cfc121
	.word cfc122, cfc123, cfc124, cfc125, cfc126, cfc127, cfc128
	.word cfc129, cfc130, cfc131

	.text
	.globl std_cfc1
	.ent std_cfc1
std_cfc1: 	# value = cfc1(reg)
	la	t0,cfc1L
	sll	a0,2
	addu	a0,t0
	lw	t0,(a0)
	j	t0

cfc10:	cfc1	v0,$0; b	1f
cfc11:	cfc1	v0,$1; b	1f
cfc12:	cfc1	v0,$2; b	1f
cfc13:	cfc1	v0,$3; b	1f
cfc14:	cfc1	v0,$4; b	1f
cfc15:	cfc1	v0,$5; b	1f
cfc16:	cfc1	v0,$6; b	1f
cfc17:	cfc1	v0,$7; b	1f
cfc18:	cfc1	v0,$8; b	1f
cfc19:	cfc1	v0,$9; b	1f
cfc110:	cfc1	v0,$10; b	1f
cfc111:	cfc1	v0,$11; b	1f
cfc112:	cfc1	v0,$12; b	1f
cfc113:	cfc1	v0,$13; b	1f
cfc114:	cfc1	v0,$14; b	1f
cfc115:	cfc1	v0,$15; b	1f
cfc116:	cfc1	v0,$16; b	1f
cfc117:	cfc1	v0,$17; b	1f
cfc118:	cfc1	v0,$18; b	1f
cfc119:	cfc1	v0,$19; b	1f
cfc120:	cfc1	v0,$20; b	1f
cfc121:	cfc1	v0,$21; b	1f
cfc122:	cfc1	v0,$22; b	1f
cfc123:	cfc1	v0,$23; b	1f
cfc124:	cfc1	v0,$24; b	1f
cfc125:	cfc1	v0,$25; b	1f
cfc126:	cfc1	v0,$26; b	1f
cfc127:	cfc1	v0,$27; b	1f
cfc128:	cfc1	v0,$28; b	1f
cfc129:	cfc1	v0,$29; b	1f
cfc130:	cfc1	v0,$30; b	1f
cfc131:	cfc1	v0,$31
1:	j	ra
	.end std_cfc1

	.data
ctc1L:	.word ctc10, ctc11, ctc12, ctc13, ctc14, ctc15, ctc16, ctc17
	.word ctc18, ctc19, ctc110, ctc111, ctc112, ctc113, ctc114
	.word ctc115, ctc116, ctc117, ctc118, ctc119, ctc120, ctc121
	.word ctc122, ctc123, ctc124, ctc125, ctc126, ctc127, ctc128
	.word ctc129, ctc130, ctc131

	.text
	.globl std_ctc1
	.ent std_ctc1
std_ctc1:	# ctc1(reg,value)
	la	t0,ctc1L
	sll	a0,2
	addu	a0,t0
	lw	t0,(a0)
	j	t0

ctc10:	ctc1	a1,$0; b	1f
ctc11:	ctc1	a1,$1; b	1f
ctc12:	ctc1	a1,$2; b	1f
ctc13:	ctc1	a1,$3; b	1f
ctc14:	ctc1	a1,$4; b	1f
ctc15:	ctc1	a1,$5; b	1f
ctc16:	ctc1	a1,$6; b	1f
ctc17:	ctc1	a1,$7; b	1f
ctc18:	ctc1	a1,$8; b	1f
ctc19:	ctc1	a1,$9; b	1f
ctc110:	ctc1	a1,$10; b	1f
ctc111:	ctc1	a1,$11; b	1f
ctc112:	ctc1	a1,$12; b	1f
ctc113:	ctc1	a1,$13; b	1f
ctc114:	ctc1	a1,$14; b	1f
ctc115:	ctc1	a1,$15; b	1f
ctc116:	ctc1	a1,$16; b	1f
ctc117:	ctc1	a1,$17; b	1f
ctc118:	ctc1	a1,$18; b	1f
ctc119:	ctc1	a1,$19; b	1f
ctc120:	ctc1	a1,$20; b	1f
ctc121:	ctc1	a1,$21; b	1f
ctc122:	ctc1	a1,$22; b	1f
ctc123:	ctc1	a1,$23; b	1f
ctc124:	ctc1	a1,$24; b	1f
ctc125:	ctc1	a1,$25; b	1f
ctc126:	ctc1	a1,$26; b	1f
ctc127:	ctc1	a1,$27; b	1f
ctc128:	ctc1	a1,$28; b	1f
ctc129:	ctc1	a1,$29; b	1f
ctc130:	ctc1	a1,$30; b	1f
ctc131:	ctc1	a1,$31
1:	j	ra
	.end std_ctc1

	.data
mfc1L:	.word mfc10, mfc11, mfc12, mfc13, mfc14, mfc15, mfc16, mfc17
	.word mfc18, mfc19, mfc110, mfc111, mfc112, mfc113, mfc114
	.word mfc115, mfc116, mfc117, mfc118, mfc119, mfc120, mfc121
	.word mfc122, mfc123, mfc124, mfc125, mfc126, mfc127, mfc128
	.word mfc129, mfc130, mfc131

	.text
	.globl std_mfc1
	.ent std_mfc1
std_mfc1:	# value = mfc1(reg)
	la	t0,mfc1L
	sll	a0,2
	addu	a0,t0
	lw	t0,(a0)
	j	t0

mfc10:	mfc1	v0,$f0; b	1f
mfc11:	mfc1	v0,$f1; b	1f
mfc12:	mfc1	v0,$f2; b	1f
mfc13:	mfc1	v0,$f3; b	1f
mfc14:	mfc1	v0,$f4; b	1f
mfc15:	mfc1	v0,$f5; b	1f
mfc16:	mfc1	v0,$f6; b	1f
mfc17:	mfc1	v0,$f7; b	1f
mfc18:	mfc1	v0,$f8; b	1f
mfc19:	mfc1	v0,$f9; b	1f
mfc110:	mfc1	v0,$f10; b	1f
mfc111:	mfc1	v0,$f11; b	1f
mfc112:	mfc1	v0,$f12; b	1f
mfc113:	mfc1	v0,$f13; b	1f
mfc114:	mfc1	v0,$f14; b	1f
mfc115:	mfc1	v0,$f15; b	1f
mfc116:	mfc1	v0,$f16; b	1f
mfc117:	mfc1	v0,$f17; b	1f
mfc118:	mfc1	v0,$f18; b	1f
mfc119:	mfc1	v0,$f19; b	1f
mfc120:	mfc1	v0,$f20; b	1f
mfc121:	mfc1	v0,$f21; b	1f
mfc122:	mfc1	v0,$f22; b	1f
mfc123:	mfc1	v0,$f23; b	1f
mfc124:	mfc1	v0,$f24; b	1f
mfc125:	mfc1	v0,$f25; b	1f
mfc126:	mfc1	v0,$f26; b	1f
mfc127:	mfc1	v0,$f27; b	1f
mfc128:	mfc1	v0,$f28; b	1f
mfc129:	mfc1	v0,$f29; b	1f
mfc130:	mfc1	v0,$f30; b	1f
mfc131:	mfc1	v0,$f31 
1:	j	ra
	.end std_mfc1

	.data
mtc1L:	.word mtc10, mtc11, mtc12, mtc13, mtc14, mtc15, mtc16, mtc17
	.word mtc18, mtc19, mtc110, mtc111, mtc112, mtc113, mtc114
	.word mtc115, mtc116, mtc117, mtc118, mtc119, mtc120, mtc121
	.word mtc122, mtc123, mtc124, mtc125, mtc126, mtc127, mtc128
	.word mtc129, mtc130, mtc131

	.text
	.globl std_mtc1
	.ent std_mtc1
std_mtc1:	# mtc1(reg,value)
	la	t0,mtc1L
	sll	a0,2
	addu	a0,t0
	lw	t0,(a0)
	j	t0

mtc10:	mtc1	a1,$f0; b	1f
mtc11:	mtc1	a1,$f1; b	1f
mtc12:	mtc1	a1,$f2; b	1f
mtc13:	mtc1	a1,$f3; b	1f
mtc14:	mtc1	a1,$f4; b	1f
mtc15:	mtc1	a1,$f5; b	1f
mtc16:	mtc1	a1,$f6; b	1f
mtc17:	mtc1	a1,$f7; b	1f
mtc18:	mtc1	a1,$f8; b	1f
mtc19:	mtc1	a1,$f9; b	1f
mtc110:	mtc1	a1,$f10; b	1f
mtc111:	mtc1	a1,$f11; b	1f
mtc112:	mtc1	a1,$f12; b	1f
mtc113:	mtc1	a1,$f13; b	1f
mtc114:	mtc1	a1,$f14; b	1f
mtc115:	mtc1	a1,$f15; b	1f
mtc116:	mtc1	a1,$f16; b	1f
mtc117:	mtc1	a1,$f17; b	1f
mtc118:	mtc1	a1,$f18; b	1f
mtc119:	mtc1	a1,$f19; b	1f
mtc120:	mtc1	a1,$f20; b	1f
mtc121:	mtc1	a1,$f21; b	1f
mtc122:	mtc1	a1,$f22; b	1f
mtc123:	mtc1	a1,$f23; b	1f
mtc124:	mtc1	a1,$f24; b	1f
mtc125:	mtc1	a1,$f25; b	1f
mtc126:	mtc1	a1,$f26; b	1f
mtc127:	mtc1	a1,$f27; b	1f
mtc128:	mtc1	a1,$f28; b	1f
mtc129:	mtc1	a1,$f29; b	1f
mtc130:	mtc1	a1,$f30; b	1f
mtc131:	mtc1	a1,$f31 
1:	j	ra
	.end std_mtc1
	.set noreorder
	nop

