/*************************************************************
 * File: lib/cp0supp.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	970421	Corrected comment describing mtc0
 *	970910	Added code to make mtc0 use kseg1 if it was called from kseg1
 */

#include "mips.h"

/*
** Support for coprocessor 0
**
**	value = mfc0(reg)
**	mtc0(reg,value)
*/

	.data
mfc0L:	.word mfc00, mfc01, mfc02, mfc03, mfc04, mfc05, mfc06, mfc07
	.word mfc08, mfc09, mfc010, mfc011, mfc012, mfc013, mfc014
	.word mfc015, mfc016, mfc017, mfc018, mfc019, mfc020, mfc021
	.word mfc022, mfc023, mfc024, mfc025, mfc026, mfc027, mfc028
	.word mfc029, mfc030, mfc031

	.text
	.globl std_mfc0
	.ent std_mfc0
std_mfc0:	# value = mfc0(reg)
	la	t0,mfc0L
	sll	a0,2
	addu	a0,t0
	lw	t0,(a0)
	j	t0

	.set noreorder
mfc00:	mfc0	v0,$0; nop;	b	1f;	nop
mfc01:	mfc0	v0,$1; nop;	b	1f;	nop
mfc02:	mfc0	v0,$2; nop;	b	1f;	nop
mfc03:	mfc0	v0,$3; nop;	b	1f;	nop
mfc04:	mfc0	v0,$4; nop;	b	1f;	nop
mfc05:	mfc0	v0,$5; nop;	b	1f;	nop
mfc06:	mfc0	v0,$6; nop;	b	1f;	nop
mfc07:	mfc0	v0,$7; nop;	b	1f;	nop
mfc08:	mfc0	v0,$8; nop;	b	1f;	nop
mfc09:	mfc0	v0,$9; nop;	b	1f;	nop
mfc010:	mfc0	v0,$10; nop;	b	1f;	nop
mfc011:	mfc0	v0,$11; nop;	b	1f;	nop
mfc012:	mfc0	v0,$12; nop;	b	1f;	nop
mfc013:	mfc0	v0,$13; nop;	b	1f;	nop
mfc014:	mfc0	v0,$14; nop;	b	1f;	nop
mfc015:	mfc0	v0,$15; nop;	b	1f;	nop
mfc016:	mfc0	v0,$16; nop;	b	1f;	nop
mfc017:	mfc0	v0,$17; nop;	b	1f;	nop
mfc018:	mfc0	v0,$18; nop;	b	1f;	nop
mfc019:	mfc0	v0,$19; nop;	b	1f;	nop
mfc020:	mfc0	v0,$20; nop;	b	1f;	nop
mfc021:	mfc0	v0,$21; nop;	b	1f;	nop
mfc022:	mfc0	v0,$22; nop;	b	1f;	nop
mfc023:	mfc0	v0,$23; nop;	b	1f;	nop
mfc024:	mfc0	v0,$24; nop;	b	1f;	nop
mfc025:	mfc0	v0,$25; nop;	b	1f;	nop
mfc026:	mfc0	v0,$26; nop;	b	1f;	nop
mfc027:	mfc0	v0,$27; nop;	b	1f;	nop
mfc028:	mfc0	v0,$28; nop;	b	1f;	nop
mfc029:	mfc0	v0,$29; nop;	b	1f;	nop
mfc030:	mfc0	v0,$30; nop;	b	1f;	nop
mfc031:	mfc0	v0,$31; nop
	.set reorder
1:	j	ra
	.end std_mfc0

	.data
mtc0L:	.word mtc00, mtc01, mtc02, mtc03, mtc04, mtc05, mtc06, mtc07
	.word mtc08, mtc09, mtc010, mtc011, mtc012, mtc013, mtc014
	.word mtc015, mtc016, mtc017, mtc018, mtc019, mtc020, mtc021
	.word mtc022, mtc023, mtc024, mtc025, mtc026, mtc027, mtc028
	.word mtc029, mtc030, mtc031

	.text
	.globl std_mtc0
	.ent std_mtc0
	/* 970910 If this function is called from kseg1, it will use kseg1
	 * for the mtc0 instruction.
	 */
std_mtc0:	# mtc0(reg,value)
	la	t0,mtc0L
	sll	a0,2
	addu	a0,t0
	lw	t0,(a0)
	la	t1,1f
   1:	sll	t1,2
   	bgez	t1,1f
   	or	t0,K1BASE
   1:
	j	t0

	.set noreorder
mtc00:	mtc0	a1,$0; b	1f;	nop
mtc01:	mtc0	a1,$1; b	1f;	nop
mtc02:	mtc0	a1,$2; b	1f;	nop
mtc03:	mtc0	a1,$3; b	1f;	nop
mtc04:	mtc0	a1,$4; b	1f;	nop
mtc05:	mtc0	a1,$5; b	1f;	nop
mtc06:	mtc0	a1,$6; b	1f;	nop
mtc07:	mtc0	a1,$7; b	1f;	nop
mtc08:	mtc0	a1,$8; b	1f;	nop
mtc09:	mtc0	a1,$9; b	1f;	nop
mtc010:	mtc0	a1,$10; b	1f;	nop
mtc011:	mtc0	a1,$11; b	1f;	nop
mtc012:	mtc0	a1,$12; b	1f;	nop
mtc013:	mtc0	a1,$13; b	1f;	nop
mtc014:	mtc0	a1,$14; b	1f;	nop
mtc015:	mtc0	a1,$15; b	1f;	nop
mtc016:	mtc0	a1,$16; b	1f;	nop
mtc017:	mtc0	a1,$17; b	1f;	nop
mtc018:	mtc0	a1,$18; b	1f;	nop
mtc019:	mtc0	a1,$19; b	1f;	nop
mtc020:	mtc0	a1,$20; b	1f;	nop
mtc021:	mtc0	a1,$21; b	1f;	nop
mtc022:	mtc0	a1,$22; b	1f;	nop
mtc023:	mtc0	a1,$23; b	1f;	nop
mtc024:	mtc0	a1,$24; b	1f;	nop
mtc025:	mtc0	a1,$25; b	1f;	nop
mtc026:	mtc0	a1,$26; b	1f;	nop
mtc027:	mtc0	a1,$27; b	1f;	nop
mtc028:	mtc0	a1,$28; b	1f;	nop
mtc029:	mtc0	a1,$29; b	1f;	nop
mtc030:	mtc0	a1,$30; b	1f;	nop
mtc031:	mtc0	a1,$31 
	.set reorder
1:	j	ra
	.end std_mtc0
	.set noreorder
	nop

