/*************************************************************
 * File: lib/c400x.c
 * Purpose: Part of C runtime library
 *	Contains code that is common to all 400x parts.
 *	eg. 4001, 4002, 4003.
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970515	Created from pmon/main.c
 *	980421	added cache_size to cache_cmd
 */

#ifndef LR4002
#define LR4002
#endif

#include "mips.h"
#include <termio.h>
#include <terms.h>
#include <pmon.h>

#define LCK_BIT         (1<<4)  /* 400x */

Ulong specialRead400x(), readCache400x();
extern int dcache_size;
extern int icache_size;
extern int cache_line_size;
extern BrkList brkList[];

/*************************************************************
*/
Ulong readCache400x(set,what,addr)
int set,what;
Ulong addr;
{
Ulong cfg,tmpcfg,val;

tmpcfg = cfg = read_target(XT_MEM,M_CFG4001,4);

tmpcfg &= ~(CFG_CMODEMASK|CFG_IS1EN|CFG_ICEN|CFG_DSIZEMASK|CFG_ISIZEMASK);
tmpcfg |= CFG_DCEN;
tmpcfg &= ~(CFG_WBEN|CFG_PGSZMASK);

if (what == ICACHETAG) tmpcfg |= (CFG_ICEN|CFG_CMODE_ITEST);
else if (what == ICACHERAM) tmpcfg |= (CFG_ICEN|CFG_CMODE_IDATA);
else if (what == DCACHETAG) tmpcfg |= CFG_CMODE_DTEST;
else if (what == DCACHERAM) return(0); /* there is no way to read this */

if ((what == ICACHERAM || what == ICACHETAG) && set) tmpcfg |= CFG_IS1EN;
else if (what == DCACHERAM || what == DCACHETAG) /* only one set */ ;

val = specialRead400x(addr,tmpcfg);
if (0) printf("specialRead400x(%08x,%08x)=%08x\n",addr,tmpcfg,val);
return(val);
}


/*************************************************************
*/
writeCache400x(set,what,addr,val)
int set,what;
Ulong addr,val;
{
Ulong tmpcfg;

tmpcfg = read_target(XT_MEM,M_CFG4001,4);

tmpcfg &= ~(CFG_CMODEMASK|CFG_IS1EN|CFG_ICEN|CFG_DSIZEMASK|CFG_ISIZEMASK);
tmpcfg |= CFG_DCEN;

if (what == ICACHETAG) tmpcfg |= (CFG_ICEN|CFG_CMODE_ITEST);
else if (what == ICACHERAM) tmpcfg |= (CFG_ICEN|CFG_CMODE_IDATA);
else if (what == DCACHETAG) tmpcfg |= CFG_CMODE_DTEST;
else if (what == DCACHERAM) ;
 
if ((what == ICACHERAM || what == ICACHETAG) && set) tmpcfg |= CFG_IS1EN;
else if (what == DCACHERAM || what == DCACHETAG) /* only one set */ ;
 
if (verbose) fprintf(dfp,"specialWrite400x(%08x,%08x,%08x)\n",addr,tmpcfg,val);
specialWrite400x(addr,tmpcfg,val);
}

/*************************************************************
*/
Optdesc cache_opts400x[] = {
	{"[-vidl][set [addr]]","display cache"},
	{"set","select set (default 0)"},
	{"addr","specify address"},
	{"-i","display icache"},
	{"-d","display dcache (default)"},
	{"-v","display only valid entries"},
	{"-l","display only locked entries"},
	{0}};

cache_cmd400x(ac,av)
int ac;
char *av[];
{
int n,i,j,set,vflag,lflag,iflag,cachetag;
static Ulong next_adr;
Ulong adr,tag,msk,dadr;
int cache_size;

vflag = lflag = iflag = 0;
for (n=0,i=1;i<ac;i++) {
	if (av[i][0] == '-') {
		if (strequ(av[i],"-v")) vflag = 1;
		else if (strequ(av[i],"-l")) lflag = 1;
		else if (strequ(av[i],"-i")) iflag = 1;
		else if (strequ(av[i],"-d")) iflag = 0;
		else {
			printf("%s: unknown option\n",av[i]);
			return;
			}
		}
	else if (n==0) {
		if (!get_rsa(&set,av[i])) return;
		n++;
		}
	else if (n==1) {
		if (!get_rsa(&adr,av[i])) return;
		n++;
		}
	else {
		printf("%s: too many args\n",av[i]);
		return;
		}
	}
if (n==0) set = 0;
if (n<2) adr = next_adr;

adr &= ~(cache_line_size-1); /* cache lines always start on line boundaries */
if (iflag) {
	cachetag = ICACHETAG;
	cache_size = icache_size;
	msk = icache_size-1;
	}
else {
	cachetag = DCACHETAG;
	cache_size = dcache_size;
	msk = dcache_size-1;
	}

printf("Displaying %s set %d\n",(iflag)?"icache":"dcache",set);
for (n=j=0;j<8;adr += cache_line_size,n++) {
	if (n >= cache_size/cache_line_size) break;
	tag = readCache400x(set,cachetag,adr);
	if (vflag && (tag&0xf)==0) continue;
	if (lflag && (tag&0x10)==0) continue;
	printf("%08x  ",adr);
	if (iflag) {
		printf("%08x ",readCache400x(set,ICACHERAM,adr));
		printf("%08x ",readCache400x(set,ICACHERAM,adr+4));
		printf("%08x ",readCache400x(set,ICACHERAM,adr+8));
		printf("%08x ",readCache400x(set,ICACHERAM,adr+12));
		}
	else {
		dadr = K0BASE|(tag&~msk)|(adr&msk);

		/* 970225 you can only display the data if the valid 
		 * bit is set 
		 */
		if (tag&1) printf("%08x ",read_target(XT_MEM,dadr+0,4));
		else printf("xxxxxxxx ");
		if (tag&2) printf("%08x ",read_target(XT_MEM,dadr+4,4));
		else printf("xxxxxxxx ");
		if (tag&4) printf("%08x ",read_target(XT_MEM,dadr+8,4));
		else printf("xxxxxxxx ");
		if (tag&8) printf("%08x ",read_target(XT_MEM,dadr+12,4));
		else printf("xxxxxxxx ");
		}
	printf(" %08x\n",tag);
	j++;
	}
next_adr = adr;
}

/*************************************************************
*  ilockReq400x(addr)
*       verify that other ilock bpts don't conflict with this one
*               (ie. are a cachesize multiple apart).
*       Also verify that lock bit is not already set.
*/
ilockReq400x(addr)
Ulong addr;
{
Ulong tag,tmsk,omsk;
int i;

tag = readCache400x(0,ICACHETAG,addr);
if (tag&LCK_BIT) {
	if (verbose) fprintf(dfp,"ilockReq: LCK_BIT is set\n");
	return(0);
	}

tmsk = (icache_size)-1; /* tag mask */
omsk = tmsk&~(cache_line_size-1); /* offset mask */
for (i=0;i<MAX_BPT;i++) {
        if (brkList[i].type==0) continue;
        if (brkList[i].method != BRK_METHOD_ROM) continue;
        if ((addr&omsk) != (brkList[i].addr&omsk)) continue; /* not same line */
	if ((addr&~tmsk) == (brkList[i].addr&~tmsk)) {
		if (verbose) fprintf(dfp,"ilockReq: same tag\n");
		return(0); /* same tag */
		}
        }
return(1);
}

