/*************************************************************
 * File: lib/c33300.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	971115	Added code to set re_sonic for LE
 *	980615	Renamed re_sonic re_ether
 *	980616	Added "case 8" devinit.
 *	980730	Added F_MIPS for Crossview.
 *	980730	Fixed the HI reg #.
 */

#ifndef LR33300
#define LR33300
#endif
#include <pmon.h>
#include <termio.h>
#include <terms.h>

char *l33300bsv[] = {"2","4","8","16",0};


RegSpec l333biu[] = {
        {1,17,"NOSTR",2,0,0},
        {1,16,"LDSCH",2,0,0},
	{1,15,"BGNT",2,0,0},
	{1,14,"NOPAD",2,0,0},
	{1,13,"RDPRI",2,0,0},
	{1,12,"INTP",2,0,0},
	{1,11,"IS1",2,0,0},
	{1,10,"IS0",2,0,0},
	{2,8,"IBLKSZ",0,l33300bsv,0},
	{1,7,"DS1",2,0,0},
	{1,6,"DS0",2,0,0},
	{2,4,"DBLKSZ",0,l33300bsv,0},
	{1,3,"RAM",2,0,0},
	{1,2,"TAG",2,0,0},
	{1,1,"INV",2,0,0},
	{1,0,"LOCK",2,0,0},
	{0}};

RegSpec DramCfgreg[] = {
        {1,28,"DLP1",2,0,0}, 
        {1,27,"SYNC",2,0,0},
        {1,26,"SCFG",2,0,0},
        {1,25,"DMARDY",2,0,0}, 
        {3,22,"DMABLK",10,0,0}, 
        {2,20,"DPTH",10,0,0}, 
	{1,19,"RDYW",2,0,0},
	{3,16,"PGSZ",10,0,0},
	{1,15,"PGMW",2,0,0},
	{2,13,"RFWE",2,0,0},
	{1,12,"RFEN",2,0,0},
	{1,11,"RDYEN",2,0,0},
	{1,10,"BFD",2,0,0},
	{1,9,"PE",2,0,0},
	{2,7,"RPC",10,0,0},
	{2,5,"RCD",10,0,0},
	{1,4,"CS",2,0,0},
	{3,1,"CL",10,0,0},
	{1,0,"DCE",2,0,0},
        {0}};

RegSpec SpecN[] = {
        {4,24,"INHIBIT",10,0,0},
        {1,23,"EXTGNT",2,0,0}, 
        {1,22,"16WIDE",2,0,0}, 
        {1,21,"8WIDE",2,0,0}, 
        {1,20,"PENA",2,0,0}, 
        {1,19,"CACHED",2,0,0}, 
        {2,17,"CSDLY",10,0,0}, 
        {1,16,"BLKENA",2,0,0}, 
        {3,13,"BLKWAIT",10,0,0}, 
        {6,7,"REC",10,0,0}, 
        {1,6,"WAITENA", 2,0,0}, 
        {6,0,"WAIT",10,0,0}, 
        {0}}; 

RegRec c33300_reglist[] = {
	{mXpc,0,"PC","pc",14,(F_MIPS|F_CPU)},
	{mXgpr,0,"HI","HI",32,(F_CPU|F_MIPS)},
	{mXgpr,0,"LO","LO",33,(F_CPU|F_MIPS)},
	/* ========== cp0 ========== */
	{mXc0,mips_sr_def,"C0_SR","SR",12,(F_CP0|F_MIPS)},
	{mXc0,mips_cause_def,"C0_CAUSE","CAUSE",13,(F_CP0|F_MIPS)},
	{mXc0,mips_prid_def,"C0_PRID","PRID",15,(F_CP0|F_RO|F_MIPS)},
	{mXc0,0,"C0_EPC","EPC",14,(F_CP0|F_MIPS)},
	{mXc0,0,"C0_BADVA","BADVA",8,(F_CP0|F_MIPS)},
/*--------- end of basic MIPS stuff ------------------------*/
	{mXmem,l333biu,"M_BIU","BIU",M_BIU,(0)},
	{mXmem,DramCfgreg,"M_DRAM","DRAM",M_DRAM,(0)},
	{mXmem,SpecN,"M_SRAM","SRAM",M_SRAM,(0)},
	{mXmem,SpecN,"M_SPEC0","SPEC0",M_SPEC0,(0)},
	{mXmem,SpecN,"M_SPEC1","SPEC1",M_SPEC1,(0)},
	{mXmem,SpecN,"M_SPEC2","SPEC2",M_SPEC2,(0)},
	{mXmem,SpecN,"M_SPEC3","SPEC3",M_SPEC3,(0)},
	{0}};

RegSpec DCIC[] = {
	{1,31,"TR",2,0,0},
	{1,30,"UD",2,0,0},
	{1,29,"KD",2,0,0},
	{1,28,"TE",2,0,0},
	{1,27,"DW",2,0,0},
	{1,26,"DR",2,0,0},
	{1,25,"DAE",2,0,0},
	{1,24,"PCE",2,0,0},
	{1,23,"DE",2,0,0},
	{1,13,"D",2,0,0},
	{1,12,"I",2,0,0},
	{1,5,"T",2,0,0},
	{1,4,"W",2,0,0},
	{1,3,"R",2,0,0},
	{1,2,"DA",2,0,0},
	{1,1,"PC",2,0,0},
	{1,0,"DG",2,0,0},
	{0}};

char *c33300_c0regs[] = {
	"$0",     "$1",  "$2",  "C0_BPC",  
	"$4",   "C0_BDA",   "C0_TAR",    "C0_DCIC",
 	"C0_BADADDR", "C0_BDAM",  "$10",  "C0_BPCM", 
	"C0_SR",      "C0_CAUSE", "C0_EPC",    "C0_PRID",
	"$16", "$17", "$18", "$19", "$20", "$21", "$22", "$23",
	"$24", "$25", "$26", "$27", "$28", "$29", "$30", "$31"
	};

int p2681();
static struct p2681info tty1dat = {0xbe000000,3,4};

#ifndef PMCC
a33300init(type) { c33300init(type); }
#endif

c33300init(type)
int type;
{
int i;

switch (type) {
	case 1 :
		break;
	case 2 :
                c0regNames = c33300_c0regs;
                for (i=0;c33300_reglist[i].func;i++) {
                        addRegRec(&c33300_reglist[i]);
                        }
		break;
	case 5 :
#if defined(ETHERNET) && !defined(MIPSEB)
		re_ether = 1;
#endif
		break;
	case 8 : 
		addDevice((Addr)&tty1dat,0,p2681,1024,DEFBAUD);
		addDevice((Addr)&tty1dat,1,p2681,1024,DEFBAUD);
#ifdef ETHERNET
		ether_driver_ptr = sonic_driver;
#endif
		break;
	}
}
