/*************************************************************
 * File: lib/c33020.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	980616	Added "case 8" devinit.
 *	980730	Added F_MIPS for Crossview.
 *	980730	Fixed the HI reg #.
 */

#ifndef LR33020
#define LR33020
#endif
#include <mon.h>
#include <termio.h>
#include <terms.h>

char *c33020_c0regs[] = {
	"$0",     "$1",  "$2",  "C0_BPC",  
	"$4",   "C0_BDA",   "$6",    "$7",
 	"C0_BADADDR", "$9",       "$10",  "$11", 
	"C0_SR",      "C0_CAUSE", "C0_EPC",    "C0_PRID",
	"$16", "$17", "$18", "$19", "$20", "$21", "$22", "$23",
	"$24", "$25", "$26", "$27", "$28", "$29", "$30", "$31"
	};

char *l33020bsv[] = {"2","4","8","16",0};

char *l33020psz[] = {"64","128","256","512","1024","2048","4096","8192",0};

RegSpec l33120cfg[] = {
	{1,31,"XLE",2,0,0},
	{1,30,"BEN",2,0,0},
	{3,27,"PGSZ",0,l33020psz,0},
	{1,23,"ICD",2,0,0},
	{1,22,"DCD",2,0,0},
	{2,20,"IBS",0,l33020bsv,0},
	{2,18,"DBS",0,l33020bsv,0},
	{1,17,"IW",2,0,0},
	{4,13,"IWAIT",10,0,0},
	{1,12,"PW",2,0,0},
	{4,8,"PWAIT",10,0,0},
	{3,5,"BNK",10,0,0},
	{1,4,"BFD",2,0,0},
	{1,3,"REN",2,0,0},
	{1,2,"RPC",2,0,0},
	{1,1,"CL",2,0,0},
	{1,0,"DCE",2,0,0},
	{0}};

RegSpec l33020cfg[] = {
	{1,30,"BEN",2,0,0},
	{3,27,"PGSZ",0,l33020psz,0},
	{1,23,"ICD",2,0,0},
	{1,22,"DCD",2,0,0},
	{2,20,"IBS",0,l33020bsv,0},
	{2,18,"DBS",0,l33020bsv,0},
	{1,17,"IW",2,0,0},
	{4,13,"IWAIT",10,0,0},
	{1,12,"PW",2,0,0},
	{4,8,"PWAIT",10,0,0},
	{3,5,"BNK",10,0,0},
	{1,4,"BFD",2,0,0},
	{1,3,"REN",2,0,0},
	{1,2,"RPC",2,0,0},
	{1,1,"CL",2,0,0},
	{1,0,"DCE",2,0,0},
	{0}};

RegSpec c2pscomm[] = { /* creg25 */
	{1,7,"IO",2,0,0},
	{1,4,"CLKINH",2,0,0},
	{1,3,"RCVINT",2,0,0},
	{1,2,"TXINT",2,0,0},
	{1,1,"TXEN",2,0,0},
	{1,0,"INTHTX",2,0,0},
	{0}};

RegSpec c2psstat[] = { /* creg24 */
	{1,7,"FERR",2,0,0},
	{1,6,"PAR",2,0,0},
	{1,5,"RXIN",2,0,0},
	{1,4,"RXBF",2,0,0},
	{1,3,"TXBE",2,0,0},
	{1,2,"TXIN",2,0,0},
	{1,1,"CLKX",2,0,0},
	{1,0,"CLK",2,0,0},
	{0}};

RegSpec c2config120[] = { /* 33120 creg9 */
	{1,24,"BENDS",2,0,0},	
	{1,23,"BW8",2,0,0},
	{1,22,"INLVDBW",2,0,0},
	{1,21,"QSF",2,0,0},
	{1,19,"HCUR",2,0,0},
	{1,18,"DRAM",2,0,0},
	{1,17,"SAM",2,0,0},
	{1,16,"VRAM",2,0,0},
	{1,15,"D3",2,0,0},
	{3,12,"IORV3",10,0,0},
	{4,8,"IOWAIT3",10,0,0},
	{1,7,"D2",2,0,0},
	{3,4,"IORV2",10,0,0},
	{4,0,"IOWAIT2",10,0,0},
	{0}};

RegSpec c2config020[] = { /* 33020 creg9 */
	{1,21,"QSF",2,0,0},
	{1,19,"HCUR",2,0,0},
	{1,18,"DRAM",2,0,0},
	{1,17,"SAM",2,0,0},
	{1,16,"VRAM",2,0,0},
	{1,15,"D3",2,0,0},
	{3,12,"IORV3",10,0,0},
	{4,8,"IOWAIT3",10,0,0},
	{1,7,"D2",2,0,0},
	{3,4,"IORV2",10,0,0},
	{4,0,"IOWAIT2",10,0,0},
	{0}};

RegSpec c2vhwconfig[] = { /* dreg23 */
	{1,31,"EN",2,0,0},
	{1,18,"CROSSINV",2,0,0},
	{1,17,"CROSSDAT",2,0,0},
	{1,16,"CROSSEN",2,0,0},
	{1,15,"CSYNCEN",2,0,0},
	{1,14,"OVRSCN",2,0,0},
	{1,13,"VEND",2,0,0},
	{1,12,"VSYNCOUTEN",2,0,0},
	{1,11,"VSYNCINEN",2,0,0},
	{1,10,"HWCRSR",2,0,0},
	{2,8,"SHFT",10,0,0},
	{1,7,"VSPOS",2,0,0},
	{1,6,"HSPOS",2,0,0},
	{1,5,"VSINT",2,0,0},
	{1,4,"HLINT",2,0,0},
	{1,1,"VLINTEN",2,0,0},
	{1,0,"HLINTEN",2,0,0},
	{0}};

RegSpec c2srcshift120[] = { /* 33120 creg1 */
	{5,5,"INC",10,0,0,},
	{5,0,"SHIFT",10,0,0},
	{0}};

char *pixszvalues[] = {"1","2","4","8","16","32","X","X",0};

RegSpec c2gcpcntrl[] = { /* creg4 */
	{2,13,"SPCLWE",10,0,0},
	{1,12,"YDIR",2,0,0},
	{1,11,"XDIR",2,0,0},
	{1,9,"WO",2,0,0},
	{1,8,"MW",2,0,0},
	{1,6,"MASK",2,0,0,},
	{1,4,"EXPND",2,0,0,},
	{1,3,"TRAN",2,0,0,},
	{3,0,"PIXSIZ",0,pixszvalues,0},
	{0}};

RegRec c33020_reglist[] = {
	{mXpc,0,"PC","pc",14,(F_MIPS|F_CPU)},
	{mXgpr,0,"HI","HI",32,(F_CPU|F_MIPS)},
	{mXgpr,0,"LO","LO",33,(F_CPU|F_MIPS)},
	/* ========== cp0 ========== */
	{mXc0,mips_sr_def,"C0_SR","SR",12,(F_CP0|F_MIPS)},
	{mXc0,mips_cause_def,"C0_CAUSE","CAUSE",13,(F_CP0|F_MIPS)},
	{mXc0,mips_prid_def,"C0_PRID","PRID",15,(F_CP0|F_RO|F_MIPS)},
	{mXc0,0,"C0_EPC","EPC",14,(F_CP0|F_MIPS)},
	{mXc0,0,"C0_BADVA","BADVA",8,(F_CP0|F_MIPS)},
/*--------- end of basic MIPS stuff ------------------------*/
	{mXmem,l33020cfg,"M_CFG","CFG",M_CFGREG,(0)},
	{mXmem,l33120cfg,"M_CFG","CFG",M_CFGREG,(0)},
#ifdef ALPHABETICAL
	{cXc2,0,"C2_COLOR0","COLOR0",2,(0)},
	{cXc2,0,"C2_COLOR1","COLOR1",3,(0)},
	{cXc2,c2config020,"C2_CONFIG","CONFIG",9,(0)},
	{cXc2,c2config120,"C2_CONFIG","CONFIG",9,(0)},
	{cXc2,0,"C2_PLANEMASK","PLANEMASK",6,(0)},
	{cXc2,0,"C2_RASTEROP","RASTEROP",5,(0)},
	{cXc2,0,"C2_SRCSHIFT","SRCSHIFT",1,(0)},
	{cXc2,c2srcshift120,"C2_SRCSHIFT","SRCSHIFT",1,(0)},
	{cXc2,0,"C2_SRCSKEW","SRCSKEW",0,(0)},
	{cXc2,c2gcpcntrl,"C2_GCPCNTRL","GCPCNTRL",4,(0)},
	{cXc2,c2psstat,"C2_PSSTAT","PSSTAT",24,(0|F_RO)},
	{cXc2,c2pscomm,"C2_PSCOMM","PSCOMM",25,(0)},
	{mXc2,0,"C2_BLANKE","BLANKE",21,(0)},
	{mXc2,0,"C2_BLANKS","BLANKS",18,(0)},
	{mXc2,0,"C2_CURDISP","CURDISP",6,(0)},
	{mXc2,0,"C2_DESTCURR","DESTCURR",13,(0)},
	{mXc2,0,"C2_DESTDATA","DESTDATA",29,(0)},
	{mXc2,0,"C2_DESTLINE","DESTLINE",12,(0)},
	{mXc2,0,"C2_DESTPITCH","DESTPITCH",14,(0)},
	{mXc2,0,"C2_GBLKSIZE","GBLKSIZE",15,(0)},
	{mXc2,0,"C2_HWCRSR","HWCRSR",22,(0)},
	{mXc2,0,"C2_HLINTR","HLINTR",17,(0)},
	{mXc2,0,"C2_HWCRSRSTART","HWCRSRSTART",2,(0)},
	{mXc2,0,"C2_HWCRSRCURR","HWCRSRCURR",3,(0)},
	{mXc2,0,"C2_LEFTMASK","LEFTMASK",30,(0)},
	{mXc2,0,"C2_LINECOUNT","LINECOUNT",7,(0)},
	{mXc2,0,"C2_NXTDISP","NXTDISP",5,(0)},
	{mXc2,0,"C2_PSRCVB","PSRCVB",25,(0|F_RO)},
	{mXc2,0,"C2_PSTXB","PSTXB",24,(0)},
	{mXc2,0,"C2_RIGHTMASK","RIGHTMASK",31,(0)},
	{mXc2,0,"C2_SAMEXTENT","SAMEXTENT",4,(0)},
	{mXc2,0,"C2_SCRSTART","SCRSTART",0,(0)},
	{mXc2,0,"C2_SCRPITCH","SCRPITCH",1,(0)},
	{mXc2,0,"C2_SERPULS","SERPULS",16,(0)},
	{mXc2,0,"C2_SRCDATA","SRCDATA",28,(0)},
	{mXc2,0,"C2_SRCCURR","SRCCURR",10,(0)},
	{mXc2,0,"C2_SRCLINE","SRCLINE",9,(0)},
	{mXc2,0,"C2_SRCPITCH","SRCPITCH",11,(0)},
	{mXc2,0,"C2_SYNCS","SYNCS",19,(0)},
	{mXc2,0,"C2_SYNCRESET","SYNCRESET",20,(0)},
	{mXc2,0,"C2_VBLKSIZE","VBLKSIZE",8,(0)},
	{mXc2,c2vhwconfig,"C2_VHWCONFIG","VHWCONFIG",23,(0)},
#else /* sorted by type */
	{cXc2,c2gcpcntrl,"C2_GCPCNTRL","GCPCNTRL",4,(0)},
	{cXc2,0,"C2_SRCSHIFT","SRCSHIFT",1,(0)},
	{cXc2,c2srcshift120,"C2_SRCSHIFT","SRCSHIFT",1,(0)},
	{mXc2,0,"C2_SRCLINE","SRCLINE",9,(0)},
	{mXc2,0,"C2_SRCCURR","SRCCURR",10,(0)},
	{mXc2,0,"C2_SRCPITCH","SRCPITCH",11,(0)},
	{mXc2,0,"C2_SRCDATA","SRCDATA",28,(0)},
	{mXc2,0,"C2_GBLKSIZE","GBLKSIZE",15,(0)},
	{cXc2,0,"C2_SRCSKEW","SRCSKEW",0,(0)},
	{cXc2,0,"C2_COLOR0","COLOR0",2,(0)},
	{cXc2,0,"C2_COLOR1","COLOR1",3,(0)},
	{cXc2,0,"C2_RASTEROP","RASTEROP",5,(0)},
	{mXc2,0,"C2_LEFTMASK","LEFTMASK",30,(0)},
	{mXc2,0,"C2_RIGHTMASK","RIGHTMASK",31,(0)},
	{cXc2,0,"C2_PLANEMASK","PLANEMASK",6,(0)},
	{mXc2,0,"C2_DESTLINE","DESTLINE",12,(0)},
	{mXc2,0,"C2_DESTCURR","DESTCURR",13,(0)},
	{mXc2,0,"C2_DESTPITCH","DESTPITCH",14,(0)},
	{mXc2,0,"C2_DESTDATA","DESTDATA",29,(0)},
	{mXc2,c2vhwconfig,"C2_VHWCONFIG","VHWCONFIG",23,(0)},
	{mXc2,0,"C2_SCRSTART","SCRSTART",0,(0)},
	{mXc2,0,"C2_SCRPITCH","SCRPITCH",1,(0)},
	{mXc2,0,"C2_CURDISP","CURDISP",6,(0)},
	{mXc2,0,"C2_NXTDISP","NXTDISP",5,(0)},
	{mXc2,0,"C2_LINECOUNT","LINECOUNT",7,(0)},
	{mXc2,0,"C2_VBLKSIZE","VBLKSIZE",8,(0)},
	{mXc2,0,"C2_BLANKE","BLANKE",21,(0)},
	{mXc2,0,"C2_BLANKS","BLANKS",18,(0)},
	{mXc2,0,"C2_SYNCS","SYNCS",19,(0)},
	{mXc2,0,"C2_SYNCRESET","SYNCRESET",20,(0)},
	{mXc2,0,"C2_SERPULS","SERPULS",16,(0)},
	{mXc2,0,"C2_HLINTR","HLINTR",17,(0)},
	{mXc2,0,"C2_SAMEXTENT","SAMEXTENT",4,(0)},
	{cXc2,c2config020,"C2_CONFIG","CONFIG",9,(0)},
	{cXc2,c2config120,"C2_CONFIG","CONFIG",9,(0)},
	{mXc2,0,"C2_HWCRSR","HWCRSR",22,(0)},
	{mXc2,0,"C2_HWCRSRSTART","HWCRSRSTART",2,(0)},
	{mXc2,0,"C2_HWCRSRCURR","HWCRSRCURR",3,(0)},
	{cXc2,c2psstat,"C2_PSSTAT","PSSTAT",24,(0|F_RO)},
	{cXc2,c2pscomm,"C2_PSCOMM","PSCOMM",25,(0)},
	{mXc2,0,"C2_PSRCVB","PSRCVB",25,(0|F_RO)},
	{mXc2,0,"C2_PSTXB","PSTXB",24,(0)},
#endif /* sorted by type */
	{0}};

char *regs_c2d[] = {
	"C2_SCRSTART", "C2_SCRPITCH", "C2_HWCRSRSTART", "C2_HWCRSRCURR", 
	"C2_SAMEXTENT", "C2_NXTDISP", "C2_CURDISP", "C2_LINECOUNT",
	"C2_VBLKSIZE", "C2_SRCLINE", "C2_SRCCURR", "C2_SRCPITCH",
	"C2_DESTLINE", "C2_DESTCURR", "C2_DESTPITCH", "C2_GBLKSIZE",
	"C2_SERPULS", "C2_HLINTR", "C2_BLANKS", "C2_SYNCS",
	"C2_SYNCRESET", "C2_BLANKE", "C2_HWCRSR", "C2_VHWCONFIG",
	"C2_PSTXB", "C2_PSRCVB", "$26", "$27", "C2_SRCDATA",
	"C2_DESTDATA", "C2_LEFTMASK", "C2_RIGHTMASK" 
	};

char *regs_c2c[] = {
	"C2_SRCSKEW", "C2_SRCSHIFT", "C2_COLOR0", "C2_COLOR1",
	"C2_GCPCNTRL", "C2_RASTEROP", "C2_PLANEMASK", "$7", "$8",
	"C2_CONFIG", "$10", "$11", "$12", "$13", "$14", "$15", "$16",
	"$17", "$18", "$19", "$20", "$21", "$22", "$23", "C2_PSSTAT",
	"C2_PSCOMM", "$26", "$27", "$28", "$29", "$30", "$31" 
	}; 

int p2681();
static struct p2681info tty1dat = {0xbe000000,3,4};

#ifndef PMCC
a33020init(type) { c33020init(type); }
#endif

c33020init(type)
int type;
{
int i;

switch (type) {
	case 1 : 
#ifdef PMCC
		cp2init();
#endif
		break;
	case 2 :
                c0regNames = c33020_c0regs;
                for (i=0;c33020_reglist[i].func;i++) {
                        addRegRec(&c33020_reglist[i]);
                        }

		break;
	case 8 : 
		addDevice((Addr)&tty1dat,0,p2681,1024,DEFBAUD);
		addDevice((Addr)&tty1dat,1,p2681,1024,DEFBAUD);
#ifdef ETHERNET
		ether_driver_ptr = sonic_driver;
#endif
		break;
	}
}
