/*************************************************************
 * File: lib/c33000.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	970905	Removed the empty "case 3".
 *	980616	Added "case 8" devinit.
 *	980730	Added F_MIPS for Crossview.
 *	980730	Fixed the HI reg #.
 */

#ifndef LR33000
#define LR33000
#endif
#include <mon.h>
#include <termio.h>
#include <terms.h>

char *c33000bsv[] = {"2","4","8","16",0};

RegSpec c33000cfg[] = {
	{1,23,"ICD",2,0,0},
	{1,22,"DCD",2,0,0},
	{2,20,"IBS",0,c33000bsv,0},
	{2,18,"DBS",0,c33000bsv,0},
	{1,17,"IW",2,0,0},
	{4,13,"IWAIT",10,0,0},
	{1,12,"PW",2,0,0},
	{4,8,"PWAIT",10,0,0},
	{1,7,"CS",2,0,0},
	{1,6,"PE",2,0,0},
	{1,5,"DGE",2,0,0},
	{1,4,"BFD",2,0,0},
	{1,3,"REN",2,0,0},
	{1,2,"RPC",2,0,0},
	{1,1,"CL",2,0,0},
	{1,0,"DCE",2,0,0},
	{0}};

RegSpec c33000tcl[] = {
	{1,2,"CE",2,0,0},
	{1,1,"IE",2,0,0},
	{1,0,"INT",2,0,0},
	{0}};

RegRec c33000_reglist[] = {
	{mXpc,0,"PC","pc",14,(F_MIPS|F_CPU)},
	{mXgpr,0,"HI","HI",32,(F_CPU|F_MIPS)},
	{mXgpr,0,"LO","LO",33,(F_CPU|F_MIPS)},
	{mXc0,mips_sr_def,"C0_SR","SR",12,(F_CP0|F_MIPS)},
	{mXc0,mips_cause_def,"C0_CAUSE","CAUSE",13,(F_CP0|F_MIPS)},
	{mXc0,mips_prid_def,"C0_PRID","PRID",15,(F_CP0|F_RO|F_MIPS)},
	{mXc0,0,"C0_EPC","EPC",14,(F_CP0|F_MIPS)},
	{mXc0,0,"C0_BADVA","BADVA",8,(F_CP0|F_MIPS)},
	/*------------ end of basic MIPS stuff -------------*/
	{mXmem,c33000cfg,"M_CFG","CFG",M_CFGREG,0},
	{mXmem,c33000tcl,"M_TC1","TC1",M_TC1,0},
	{mXmem,0,"M_TIC1","TIC1",M_TIC1,0},
	{mXmem,c33000tcl,"M_TC2","TC2",M_TC2,0},
	{mXmem,0,"M_TIC2","TIC2",M_TIC2,0},
	{mXmem,0,"M_RTIC","RTIC",M_RTIC,0},
	{0}};

char *c33000_c0regs[] = {
	"$0",     "$1",  "$2",  "C0_BPC",  
	"$4",   "C0_BDA",   "$6",    "$7",
 	"C0_BADADDR", "$9",       "$10",  "$11", 
	"C0_SR",      "C0_CAUSE", "C0_EPC",    "C0_PRID",
	"$16", "$17", "$18", "$19", "$20", "$21", "$22", "$23",
	"$24", "$25", "$26", "$27", "$28", "$29", "$30", "$31"
	};

int p2681();
static struct p2681info tty1dat = {0xbe000000,3,4};

#ifndef PMCC
a33000init(type) { c33000init(type); }
#endif

/*************************************************************
*/
c33000init(type)
int type;
{
int i;

switch (type) {
	case 1 :
	case 2 :
		c0regNames = c33000_c0regs;
		for (i=0;c33000_reglist[i].func;i++) {
			addRegRec(&c33000_reglist[i]);
			}

		break;
	case 8 : 
		addDevice((Addr)&tty1dat,0,p2681,1024,DEFBAUD);
		addDevice((Addr)&tty1dat,1,p2681,1024,DEFBAUD);
		break;
	}
}
