/******************************************************************/
/* Copyright (c) 2001 BRECIS Communications                       */
/*      This software is the property of BRECIS Communications    */
/*      and may not be copied or distributed in any form without  */
/*      a prior licensing arrangement.                            */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/
/*************************************************************
 * File: lib/a5000.s
 * Purpose: Part of C runtime library
 */

#ifndef BRECIS5000
#define BRECIS5000
#endif
#ifndef LR4011
#define LR4011
#endif
#include <mips.h>
#include <brecis.h>

	.comm k1tmp,4


	############# LR5000 #################
	#
	.globl a5000init
	.ent a5000init
a5000init:
	j       c5000init
	.end a5000init

/*************************************************************
*  cpuType:		
*  Return the mapped (5000, 4000, 2000, ...) cpu type in v0.
*  Return DEV_ID_REG in v1.
*  This routine MUST preserve register t3 and t4 across calls
*   because callers assume these registers are preserved.
*/
	.globl	cpuType
	.ent	cpuType
cpuType:
#ifdef BRECISDEVID
	li		v1, BRECISDEVID		/* if forcing a device ID */	
#else
	li		t0,DEV_ID_REG	/* read DEVID register	*/
	lw		v1,0(t0)
#endif
	li		t1,CPU_DEVID_MASK
	and		t0,v1,t1		/* only want the ID bits*/
	srl		t0,t0,8			/* shift right 8 bits	*/
	move	v0, t0			/* compute family */
	srl		v0,v0,4			/* top 4 bits are family bits */
	li		t2, 1000		/* multiply by 1000 decimal to get family */
	mul		v0, v0, t2
	la		t1, cpu_id_map

	/* we now have family in v0, DEV_ID_REG in v1 */

cpuTypeHunt:
	lw		t2, 0(t1)
	beqz	t2, 9f		/* end of table, use default mapping */
	beq		t2, 1, 1f
0:
	addiu	t1, 16		/* advance to next quadruple */
	b		cpuTypeHunt

1:	/* compare low 16 bits of DEV_ID_REG to find correct FPGA type */
	move	t0, v1
	and		t0, 0xffff
	lw		t2, 4(t1)
	bgt		t0, t2, 0b	/* not this FPGA */
	lw		t2, 8(t1)
	blt		t0, t2, 0b	/* not this FPGA */
	lw		v0, 12(t1)	/* get family */
9:
	j		ra
	.end	cpuType

	.globl	deviceID
	.ent	deviceID
deviceID:
#ifdef BRECISDEVID
	li		v0, BRECISDEVID		/* if forcing a device ID */	
#else
	li		t0,DEV_ID_REG	/* read DEVID register	*/
	lw		v0,0(t0)
#endif
	j		ra				
	.end	deviceID
		
/*************************************************************
*  cpuclockrate:		
*  Return cpu clk frequency based on chip type.
*/
	.globl	cpuclockrate
	.ent	cpuclockrate
cpuclockrate:
	move	t3, ra				/* preserve ra */
	bal		cpuType
	move	ra, t3				/* restore ra */
	li		t0, CPU_CLOCK_RATE		
	beq		v0, 1000, 0f		/* If Zeus */
	bne		v0, 2000, 1f		/* not Polo */
0:
	li		t0, CPU_CLOCK_RATE_POLO
1:
	move	v0, t0		
	j		ra
	.end	cpuclockrate
		
/*************************************************************
*  IsFPGA:		
*  Return non-zero if we are an fpga
*/
   .globl	IsFPGA
   .ent		IsFPGA
IsFPGA:
	move	t3, ra		/* preserve ra */
	bal		cpuType
	move	ra, t3		/* restore ra */

	li		t0, CPU_DEVID_FAM_MASK
	and		t0, v1
	beqz	t0, 1f		/* if FPGA */
	li		v0, 0
	j		ra

1:
	li		v0, 1
	j		ra	
	.end	IsFPGA				   
			
/*************************************************************
*  identify_family:		
*  Return non-zero if we are an fpga
*/
   .globl	identify_family
   .ent		identify_family
identify_family:
#ifdef BRECISDEVID
	li		v1, BRECISDEVID		/* if forcing a device ID */	
#else
	li		t0,DEV_ID_REG	/* read DEVID register	*/
	lw		v1,0(t0)
#endif
	li		t1,CPU_DEVID_FAM_MASK
	and		v0,v1,t1		/* only want the ID bits*/
	j		ra

	.end	identify_family				   

/*************************************************************
*  a5000clkfunc:		
*  clkfunc args
*	1,v = set secs to v
*	2 = get secs
*	3 = get usecs
*/
	.globl	a5000clkfunc
	.ent	a5000clkfunc
a5000clkfunc:
	beq		a0, 1, 1f
	beq		a0, 2, 2f
	beq		a0, 3, 3f
	b		9f
		
1:	/* set secs to a1 */
	sw		a1, a5000clk_seconds
	b		9f

2:	/* get time in seconds */
	lw		v0, a5000clk_seconds
	b		9f

3:	/* get time in micro-seconds */
	move	t4, ra		/* preserve ra */
	bal		cpuclockrate
	move	ra, t4		/* restore ra */
	li		v1, 1000000		
	div		v0, v1
	mflo	v1
	lw		t1, a5000clk_seconds
	mfc0	t2, C0_COMPARE
	mfc0	t3, C0_COUNT
	li		t4, 1000000					/* microseconds per second */
	mult	t1, t4
	mflo	t1							/* microseconds for seconds */
	subu	t2, t2, v0					/* start time previous interval */
	subu	t3, t3,t2					/* 1/2 cpu pipeline since last int */
	move	t4, v1
	div		t3, t4
	mflo	t3
	addu	v0, t1, t3
9:		
	j		ra
	.end	a5000clkfunc
			
/*************************************************************
*  a5000clkinit:		
*	Called from _exception in mips.s. 
*	Return address is saved in k1.
*/
	.globl	a5000clkinit
	.ent	a5000clkinit
a5000clkinit:
	la		v0, a5000clkfunc
	j		ra
	.end	a5000clkinit

/*************************************************************
*  a5000exception:
*	Called from _exception in mips.s. 
*	Return address is saved in k1.
*/
	.globl	a5000exception
	.ent	a5000exception
a5000exception:
	la	k0,k1tmp
	sw	k1,(k0)

	la	k0,k1tmp
	lw	k1,(k0)
	j	k1
	.end a5000exception

			.align	2
/* cpu_id_map is a special flag processing, mapped ID quadruple */
/* If no special processing, no entry in cpu_id_map */
/* one must still do special things for chips that emulate other chips */

cpu_id_map:		.word	1,	0x90,	0x80,	5000	/* 5000 FPGA */ 
				.word	1,	0xff,	0xb0,	2000	/* 2000 FPGA */
				.word	1,	0xaf,	0xa0,	4000	/* 4000 FPGA */		
				.word	1, 0x4f, 0x00, 1000		/* 1000 FPGA */
				.word	0,	0,		0,		0		/* end of table */


