/*************************************************************
 * File: lib/a33050.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <mips.h>

CACHE_CFG = (CR_IBLK_4|CR_DBLK_4)
WAIT_CFG = ((6<<CR_IOWAITSHFT)|(6<<CR_PWAITSHFT))
MEM_CFG = (CR_RDYGEN|CR_RFSHEN|CR_DRAMEN)

	.globl a33050init
	.ent a33050init
a33050init:
	beq     a0,zero,1f
	j       c33050init
    1:

	# must be a 33050
	li	t0,375			# 512 rows in 8ms = 15us
	sw	t0,M_RTIC	# refresh

	# turn on the RAM
	li	t0,(CACHE_CFG|WAIT_CFG|MEM_CFG|CR_WBE)
	sw	t0,M_CFGREG

	# delay to allow RAM to stabilize
	li	t0,1000
1:	subu	t0,1
	bne	t0,zero,1b

	# enable cp1
	.set noreorder
	mfc0	t0,C0_SR
	nop
	or	t0,(SR_CU1|SR_IBIT6|SR_IEC)
	mtc0	t0,C0_SR
	nop		# give it time...
	nop
	nop
	.set reorder

	# select the correct cache flushing routines
	la	s0,r33k_flush
	j	ra
	.end a33050init
