/*************************************************************
 * File: lib/trap10.h
 * Purpose: Part of the PMON5 package
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970430	Changed .word directives in struct to .space for EPI.
 */

/* Target registers index */
#define	S_ZERO		0
#define	S_AT		1
#define	S_V0		2
#define	S_V1		3
#define	S_A0		4
#define	S_A1		5
#define	S_A2		6
#define	S_A3		7
#define	S_T0		8
#define	S_T1		9
#define	S_T2		10
#define	S_T3		11
#define	S_T4		12
#define	S_T5		13
#define	S_T6		14
#define	S_T7		15
#define	S_S0		16
#define	S_S1		17
#define	S_S2		18
#define	S_S3		19
#define	S_S4		20
#define	S_S5		21
#define	S_S6		22
#define	S_S7		23
#define	S_T8		24
#define	S_T9		25
#define	S_K0		26
#define	S_K1		27
#define	S_GP		28
#define	S_SP		29
#define	S_FP		30
#define	S_RA		31
#define S_HI		32
#define S_LO		33
#define S_STATUS	34
#define S_CAUSE		35
#define S_EPC		36
#define S_RTN		37
#define NGREGS		38

#ifdef LANGUAGE_C
#include "utypes.h"

typedef struct Trap10state {
	Ulong ibuf[2];
	Ulong Gpr[NGREGS];
	} Trap10state;
#endif

#ifdef LANGUAGE_ASSEMBLY
	.data
	.struct 0
trap10_ibuf:	.space	2*4
trap10_Gpr:	.space	NGREGS*4
	.text
#endif
