#ifndef _STDIO_
#define _STDIO_

typedef struct FILE {
	int fd;
	int valid;
	unsigned char *ptr;
	unsigned char *buf;
	int cnt;
	char eof;
	char err;
	} FILE;

FILE *fopen();
char *fgets();
char *gets();

#ifndef NOANSI
int fclose(FILE *fp);
void rewind(FILE *fp);
void fflush(FILE *fp);
#endif

#if !defined(PMCC) && !defined(NOANSI)
int printf(char *fmt,...);
int sprintf(char *dst,char *fmt,...);
int sscanf(char *str,char *fmt,...);
#endif

extern FILE _iob[];

#define getc(p)		((--(p)->cnt>=0)?((int)*(p)->ptr++):_filbuf(p))
#define getchar()	getc(stdin)
#define putchar(x)	putc((x),stdout)
#define stdin 		(&_iob[0])
#define stdout 		(&_iob[1])
#define stderr 		(&_iob[2])
#define fileno(p)	((p)->fd)
#define clearerr(p)	((p)->err=(p)->eof=0)
#define feof(p)		((p)->eof)
#define ferror(p)	((p)->err)

#define OPEN_MAX 8
#define MAXLN 256

#ifndef NULL
#define NULL 0
#endif

#ifndef EOF
#define EOF  (-1)
#endif

#include <utypes.h>
#endif /* _STDIO_ */
