#ifndef _QUEUE_
#define _QUEUE_

/* Qinquiry operations */
#define Q_SIZE 1	/* Queue capacity */
#define Q_USED 2	/* space used */
#define Q_SPACE 3	/* space remaining */

#ifdef LANGUAGE_C
typedef struct Queue {
	int inp;
	int outp;
	int max;
	} Queue;

typedef unsigned char Msg;

#include <malloc.h>
Queue *Qcreate();
Msg Qget();

#define Qfull(x) ((Qinquiry(x,Q_SPACE) == 0)?1:0)
#define Qempty(x) (((x)->inp == (x)->outp)?1:0)
#else
#define Q_INP 0
#define Q_OUTP 4
#define Q_MAX 8
#define Q_SIZ 12
#endif



#endif /* _QUEUE_ */
