/* pmon.h - Part of the debugger for MIPS CPUs
 *
 * PMON Written for LSI LOGIC Corp. by Phil Bunce.
 *		Phil Bunce, 100 Dolores St. Ste 242, Carmel CA 93923
 *			pjb@carmel.com
 */

#include "mipsmon.h"
#include "mips.h"

#define NEWMEMSIZE
#define XCBUG

#define TIKRATE 256000

#define NO_BPT		-1L
#define SIGNATURE	0x4572696e

/* trace_mode states */
#define TRACE_NO	0	/* no trace/go */
#define TRACE_TB	1	/* trace & break */
#define TRACE_TG	2	/* trace & go */
#define TRACE_GB	3	/* go & break */
/*#define TRACE_DC	4	/* debug mode continue */
#define TRACE_DS	5	/* debug mode step */
#define TRACE_TN	6	/* multistep trace */
#define TRACE_SG	7	/* step & go */
#define TRACE_SS	8	/* sstep */

#ifdef LANGUAGE_C
#include "stdio.h"
#define loop for (;;)

/* external data declarations */
extern Ulong DBGREG[];	/* debugger's register value holder */
extern char *searching;
extern char date[];
extern char vers[];
extern int machtype;
extern unsigned long initial_sr;
extern Ulong topClientMem;
extern int clkfreq;
extern int vflag;
extern int cp1ok;
extern Func *c_exception_ptr;
extern Func *asm_exception_ptr;
extern int re_ether;

extern BrkList brkList[];
extern int dcache_size; 
extern int icache_size;
extern int iflush_needed;
extern Func *brkInstall_ptr;
extern Func *brkRemove_ptr;
extern Func *setbp_target_ptr;

#ifdef FLOATINGPT
#ifndef NEWFP
extern struct c1state *pmc1dat;	/* state info for FPU in PMON */
extern struct c1state *clic1dat;	/* state info for FPU in client */
#endif
#endif

/* function declarations */
Uchar *scan_byte();
#include <malloc.h>
Sym *findvalue();
unsigned long getpchist();
long disasm();
Ulong dispfp();

#define getfield(w,s,p) ((((unsigned long)w)&(((1<<s)-1)<<p))>>p)

#endif /* LANGUAGE_C */

#define Gpr		(&DBGREG[R_ZERO])
#define Hi		DBGREG[R_HI]
#define Lo		DBGREG[R_LO]
#define Status		DBGREG[R_STATUS]
#define pcReg		DBGREG[R_PC]

/* Target registers index */
#define	R_ZERO		0
#define	R_AT		1
#define	R_V0		2
#define	R_V1		3
#define	R_A0		4
#define	R_A1		5
#define	R_A2		6
#define	R_A3		7
#define	R_T0		8
#define	R_T1		9
#define	R_T2		10
#define	R_T3		11
#define	R_T4		12
#define	R_T5		13
#define	R_T6		14
#define	R_T7		15
#define	R_S0		16
#define	R_S1		17
#define	R_S2		18
#define	R_S3		19
#define	R_S4		20
#define	R_S5		21
#define	R_S6		22
#define	R_S7		23
#define	R_T8		24
#define	R_T9		25
#define	R_K0		26
#define	R_K1		27
#define	R_GP		28
#define	R_SP		29
#define	R_FP		30
#define	R_RA		31
#define R_HI		32
#define R_LO		33
#define R_STATUS	34
#define R_PC		35
#define R_K1TMP		36
#define R_CAUSE		37
#define R_BADVA		38
#define NREGS		40


#if 0
/* stuff for LEDs on Pocket Rocket and RacerX boards */
#ifdef RACERX
#define RED_LED	0x20
#define GRN_LED 0x40
#else
#define RED_LED	0x02
#define GRN_LED 0x01
#define SIOBASE 0xbe000000
#endif

#ifdef LANGUAGE_C
#define LED_OFF (*((volatile unsigned char *)SIOBASE+0x38))
#define LED_ON (*((volatile unsigned char *)SIOBASE+0x3c))
#else
#define LED_OFF SIOBASE+0x38
#define LED_ON  SIOBASE+0x3c
#endif
#endif

