/*************************************************************
 * File: include/lr64008.h
 * Purpose: include file for lr64008
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	980811	Start of revision history
 *	980811	Added lr4001 include for rap build
 *	980826	Added include of dbxcore.h
 */

#if defined(LR64008) && !defined(_LR64008_H_)
#define _LR6008_H_

/*
 * definitions for LSI Logic's L64008
 */

#if 0
		Internal Register and I/O Addresses
		-----------------------------------

PBus                 Attribute  Configuration     
Component            Register   Register Space    I/O Space
Number     Function  Address    Address (Count)   Address (Count)
---------------------------------------------------------------------
0          Reserved  bff0.0000  bff4.0000         bfe0.0000
1          EBus      bff0.0400  bff4.0400 (12)    n/a
2          DRAM      bff0.0800  bff4.0800 (4)     n/a
3          Demux     bff0.0c00  bff4.0c00 (0)     bfe0.3000 (>100)
4          Descram   bff0.1000  bff4.1000 (0?)    bfe0.4000 (96)
5          I2C       bff0.1400  bff4.1400 (0?)    bfe0.5000 (4)
6          TLX       bff0.1800  bff4.1800 (0?)    bfe0.6000 (4)
7          SIO 0     bff0.1c00  bff4.1c00 (2)     bfe0.7000 (2)
8          SIO 1     bff0.2000  bff4.2000 (2)     bfe0.8000 (2)
9          SIO 2     bff0.2400  bff4.2400 (2)     bfe0.9000 (2)
10         1284 PIO  bff0.2800  bff4.2800 (0?)    bfe0.a000 (28)
#endif

/* 980811 The 64008 uses a 400x core */
#ifndef LR4001
#define LR4001
#endif
#include <lr4001.h>
#include <dbxcore.h>

/* coprocessor zero */
#ifdef LANGUAGE_ASSEMBLY
#define C0_INDEX	$0		/* index (mmu) */
#define C0_RANDOM	$1		/* random (mmu) */
#endif
#ifdef LANGUAGE_C
#define C0_INDEX	0		/* index (mmu) */
#define C0_RANDOM	1		/* random (mmu) */
#endif

/* DRAM controller (16 bits) */
#define M_08_DRAMC	0xbff40800
#define M_08_DRAMC_TIMASK	(0xff<<8)
#define M_08_DRAMC_WC	(1<<6)
#define M_08_DRAMC_APMASK	(3<<4)
#define M_08_DRAMC_AM	(1<<3)
#define M_08_DRAMC_DM	(1<<2)
#define M_08_DRAMC_PSZMASK	(3<<0)

/* BBCC register (32 bits) */
#define M_08_BBCC	0xbfff0000
#define M_08_BBCC_WRBUF	(1<<30)	/* write buffer depth (must be 0 ) */
#define M_08_BBCC_DSNPEN	(1<<29)	/* Dcache snoop enable */
#define M_08_BBCC_ISNPEN	(1<<28)	/* Icache snoop enable */
#define M_08_BBCC_CMODEMASK	(3<<8)	/* cache mode (norm,ID,IT,DT) */
#define M_08_BBCC_RDPRI	(1<<7)	/* read priority */
#define M_08_BBCC_DRFLSZMASK	(3<<5)	/* Dcache refill size (1,-,4,-) */ 
#define M_08_BBCC_DCEN	(1<<4)	/* Dcache enable */
#define M_08_BBCC_IRFLSZMASK	(3<<2)	/* Icache refill size (1,-,4,-) */
#define M_08_BBCC_IS1EN	(1<<1)	/* Icache set 1 enable */
#define M_08_BBCC_ICEN	(1<<0)	/* Icache set 0 enable */

/* timers */
#define M_08_TIC0	0xbfff0100	/* timer0 initial count */	
#define M_08_TCC0	0xbfff0104	/* timer0 current count */
#define M_08_TIC1	0xbfff0108	/* timer1 initial count */
#define M_08_TCC1	0xbfff010c	/* timer1 current count */
#define M_08_TM0	0xbfff0110	/* mode0 */
#define M_08_TS0	0xbfff0114	/* status0 */
#define M_08_TIC2	0xbfff0120	/* timer2 initial count */
#define M_08_TCC2	0xbfff0124	/* timer2 current count */
#define M_08_TICW	0xbfff0128	/* watchdog initial count */
#define M_08_TCCW	0xbfff012c	/* watchdog current count */
#define M_08_TM1	0xbfff0130	/* mode1 */
#define M_08_TS1	0xbfff0134	/* status1 */

/* interrupt controller */
#define M_08_ISTR  0xbfff020c		/* status reg */
#define M_08_ILVLR 0xbfff0208		/* level reg */
#define M_08_IMODR 0xbfff0204		/* mode reg */
#define M_08_IMSKR 0xbfff0200		/* mask reg */

/* C2P mapping registers */
#define M_08_C2CFR	0xbfff0010	/* config */
#define M_08_C2STR	0xbfff0014	/* status */

/* SIO channels: Basically 3 8251's but without synchronous mode */
#define M_08_SIOA0	0xbff01c00	/* chan0 attribute */
#define M_08_SIOM0	0xbff41c00	/* chan0 mode */
#define M_08_SIOB0	0xbff41c02	/* chan0 baud */
#define M_08_SIOD0	0xbfe07000	/* chan0 data */
#define M_08_SIOC0	0xbfe07001	/* chan0 command */
#define M_08_SIOS0	0xbfe07001	/* chan0 status */

#define M_08_SIOA1	0xbff02000	/* chan1 attribute */
#define M_08_SIOM1	0xbff42000	/* chan1 mode */
#define M_08_SIOB1	0xbff42002	/* chan1 baud */
#define M_08_SIOD1	0xbfe08000	/* chan1 data */
#define M_08_SIOC1	0xbfe08001	/* chan1 command */
#define M_08_SIOS1	0xbfe08001	/* chan1 status */

#define M_08_SIOA2	0xbff02400	/* chan2 attribute */
#define M_08_SIOM2	0xbff42400	/* chan2 mode */
#define M_08_SIOB2	0xbff42402	/* chan2 baud */
#define M_08_SIOD2	0xbfe09000	/* chan2 data */
#define M_08_SIOC2	0xbfe09001	/* chan2 command */
#define M_08_SIOS2	0xbfe09001	/* chan2 status */

/* attribute register */
#define SIOA_UL		0x04	/* upper/lower */
#define SIOA_S1		0x02	/* size */
#define SIOA_S0		0x01	/* (32,8,16,-) */

/* mode register */
#define SIOM_S2		0x80	/* stopbits */
#define SIOM_S1		0x40	/* (-,1,1.5,2) */
#define SIOM_EP		0x20	/* even parity */
#define SIOM_PE		0x10	/* parity enable */
#define SIOM_L2		0x08	/* length */
#define SIOM_L1		0x04	/* (5,6,7,8) */
#define SIOM_B2		0x02	/* baud rate factor */
#define SIOM_B1		0x01	/* (-,1x,16x,64x) */

/* command register */
#define SIOC_IR 	0x80	/* internal reset */
#define SIOC_TIE 	0x40	/* transmitter interrupt enable */
#define SIOC_RTS 	0x20	/* RTS pin */
#define SIOC_RIE 	0x10	/* receiver interrupt enable */
#define SIOC_SBRK 	0x08	/* send break */
#define SIOC_RXEN 	0x04	/* receiver enable */
#define SIOC_DTR 	0x02	/* DTR pin */
#define SIOC_TXEN 	0x01	/* transmitter enable */

/* status register */
#define SIOS_DSR	0x80	/* DSR pin */
#define SIOS_BRK	0x40	/* break received */
#define SIOS_FE		0x20	/* framing error */
#define SIOS_OE		0x10	/* overflow error */
#define SIOS_PE		0x08	/* parity error */
#define SIOS_TXEM	0x04	/* transmitter empty */
#define SIOS_RXRDY	0x02	/* receiver ready */
#define SIOS_TXRDY	0x01	/* transmitter ready */

#endif /* LR64008 */
