/*************************************************************
 * File: include/lr4102.h
 * Purpose: defines for LSI Logic LR4102 Eval Chip
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	980615	Created
 */

#if defined(LR4102) && !defined(_LR4102_)
#define _LR4102_

#ifndef LR4001
#define LR4001
#endif

#include "lr4001.h"

#ifdef LANGUAGE_C
#define C0_RANDOM  1
#define C0_DEPC	  17
#define C0_DEBUG  16
#define C0_DESAVE 31
#else
#define C0_RANDOM  $1
#define C0_DEPC	  $17
#define C0_DEBUG  $16
#define C0_DESAVE $31
#endif

#define M_SCR1	0xbfff0000
#define M_SCR2	0xbfff0004

#define SCR1_MMU  	(1<<31)
#define SCR1_WRBUF  	(1<<30)
#define SCR1_DSNPEN 	(1<<29)
#define SCR1_ISNPEN 	(1<<28)
#define SCR1_INTCONDMASK (15<<16)
#define SCR1_CPC3EN	(1<<19) /* connect Cpc3 to int */
#define SCR1_CPC2EN	(1<<18) /* connect Cpc2 to int */
#define SCR1_CPC1EN	(1<<17) /* connect Cpc1 to int */
#define SCR1_CPC0EN	(1<<16) /* connect Cpc0 to int */
#define SCR1_DBERR 	(1<<13)
#define SCR1_PGSZMASK 	(7<<10)
#define SCR1_PGSZ_16 	(0<<10)
#define SCR1_PGSZ_32 	(1<<10)
#define SCR1_PGSZ_64 	(2<<10)
#define SCR1_PGSZ_128 	(3<<10)
#define SCR1_PGSZ_256 	(4<<10)
#define SCR1_PGSZ_512 	(5<<10)
#define SCR1_PGSZ_1K 	(6<<10)
#define SCR1_PGSZ_2K 	(7<<10)
#define SCR1_CMODEMASK 	(3<<8)
#define SCR1_CMODE_NORM  (0<<8)
#define SCR1_CMODE_IDATA (1<<8)
#define SCR1_CMODE_ITEST (2<<8)
#define SCR1_CMODE_DTEST (3<<8)
#define SCR1_RDPRI 	(1<<7)
#define SCR1_DRFLSZMASK (3<<5)
#define SCR1_DRFLSZ_1   (1<<5)
#define SCR1_DRFLSZ_2   (2<<5)
#define SCR1_DRFLSZ_4   (4<<5)
#define SCR1_DRFLSZ_8   (8<<5)
#define SCR1_DCEN 	(1<<4)
#define SCR1_IRFLSZMASK (3<<2)
#define SCR1_IRFLSZ_1   (1<<2)
#define SCR1_IRFLSZ_2   (2<<2)
#define SCR1_IRFLSZ_4   (4<<2)
#define SCR1_IRFLSZ_8   (8<<2)
#define SCR1_IS1EN 	(1<<1)
#define SCR1_ICEN 	(1<<0)

#define SCR2_TMRIE1 	(1<<21) /* TINT1E */
#define SCR2_TMRIE0 	(1<<20) /* TINT0E */
#define SCR2_MRR 	(1<<19)
#define SCR2_4101C 	(1<<17)
#define SCR2_MDUSATE  	(1<<16)
#define SCR2_MDUSATI  	(1<<15)
#define SCR2_FDBSTOP  	(1<<14)
#define SCR2_CLKDBMASK  (15<<7)
#define SCR2_CLKDDMASK  (3<<5)
#define SCR2_CLKSEL  	(1<<4)
#define SCR2_CLKPLLE  	(1<<3)
#define SCR2_CLKST  	(1<<2)
#define SCR2_CLKDCMASK  (3<<0)

#ifndef M_TMR4001
/* these defs are the same as 4001 */
#define M_TMR4001	0xbfff0100
#define O_TIC0		0
#define O_TCC0		4
#define O_TIC1		8
#define O_TCC1		12
#define O_TMODE		16
#define O_TSTAT		20
#endif

#define TMODE_E0	(1<<0)	/* timer enable */
#define TMODE_P0	(1<<1)	/* pulse (vs toggle) mode */
#define TMODE_M0	(1<<2)	/* watchdog mode */
#define TMODE_I0	(1<<3)	/* invert output */
#define TMODE_S0	(1<<4)	/* stop on zero */
#define TMODE_D0	(1<<5)	/* stop when debug mode */
#define TMODE_MASK0      0x3f

#define TMODE_E1	(1<<8)	/* timer enable */
#define TMODE_P1	(1<<9)	/* pulse (vs toggle) mode */
#define TMODE_M1	(1<<10)	/* watchdog mode */
#define TMODE_I1	(1<<11)	/* invert output */
#define TMODE_S1	(1<<12)	/* stop on zero */
#define TMODE_D1	(1<<13)	/* stop when debug mode */
#define TMODE_MASK1     (0x3f<<8)

#define TSTAT_IE0	(1<<0)	/* interrupt enable */
#define TSTAT_IN0	(1<<1)	/* interrupt status */
#define TSTAT_MASK0	 3

#define TSTAT_IE1	(1<<2)	/* interrupt enable */
#define TSTAT_IN1	(1<<3)	/* interrupt status */
#define TSTAT_MASK1	(3<<2)


/* FBUS */
#define M_FACFG0 0xbfff0400	/* address range 0 */
#define M_FACFG1 0xbfff0404	/* address range 1 */
#define M_FACFG2 0xbfff0408	/* address range 2 */
#define M_FACFG3 0xbfff040c	/* address range 3 */
#define M_FACFG4 0xbfff0410	/* address range 4 */
#define M_FACFG5 0xbfff0414	/* address range 5 */
#define M_FBUSTA 0xbfff0418	/* Bus Turnaround */
#define M_FACMP0 0xbfff0440	/* address range 0 comparitor */
#define M_FACMP1 0xbfff0444	/* address range 1 comparitor */
#define M_FACMP2 0xbfff0448	/* address range 2 comparitor */
#define M_FACMP3 0xbfff044c	/* address range 3 comparitor */
#define M_FACMP4 0xbfff0450	/* address range 4 comparitor */
#define M_FACMP5 0xbfff0454	/* address range 5 comparitor */
#define M_FBUSCMP 0xbfff0470	/* address compare register for Fbus */
#define M_FBUSAC 0xbfff0474	/* address compare register for memory etc */
#define M_FBUSCFG 0xbfff0480	/* config for non 0-5 range  */
#define M_FBURST 0xbfff0484	/* timing for burst mode  */
#define M_FSFLASH 0xbfff0488	/* timing for flash */
#define M_FSDRAM 0xbfff0490	/* cfg for edo sdram */
#define M_FDRAMT 0xbfff0494	/* timing for edo dram */
#define M_FSDRAMT 0xbfff0498	/* timing for sdram */
#define M_FSDRAM2 0xbfff049c	/* cfg for sdram */
#define M_FGPCFG 0xbfff04c0	/* cfg for gpio */
#define M_FGPOUTPUT 0xbfff04c4	/* output for gpio */
#define M_FGPINPUT 0xbfff04c8	/* input for gpio */

#define FACFG_WIDTH_8	(0<<30)
#define FACFG_WIDTH_16	(1<<30)
#define FACFG_WIDTH_32	(2<<30)
#define FACFG_GPSEL	(1<<29)
#define FACFG_RAMFLSH	(1<<28)
#define FACFG_RDADMASK	(7<<25)
#define FACFG_RDDDMASK	(3<<23)
#define FACFG_WRADMASK	(7<<20)
#define FACFG_WRDDMASK	(3<<18)
#define FACFG_CSRADMASK	(7<<15)
#define FACFG_CSWADMASK	(7<<12)
#define FACFG_CSRDDMASK	(3<<10)
#define FACFG_CSWDDMASK	(3<<8)
#define FACFG_BURST	(1<<7)
#define FACFG_XACK	(1<<6)
#define FACFG_WAIT_15	(15<<1)
#define FACFG_WAITMASK	(0x1f<<1)
#define FACFG_EN	(1<<0)

#define FACMP_MASK  	(0x1fff<<16)
#define FACMP_ADDRMASK   0xffff

#if 0 /* FACMP examples */
00001fbc        64KB starting at 1fbc0000 (default boot prom)
001f1fc0	2MB starting at 1fc00000   (boot prom)
00ff0000	16MB starting at 00000000  (SDRAM for Primary RAM)
07ff0000	128MB starting at 00000000  (SDRAM for Primary RAM)
00010000        128KB starting at 00000000 (SRAM for Primary RAM)
00ff0100	16MB starting at 01000000  (SDRAM at a1000000)
00010100	128KB starting at 01000000  (SRAM at a1000000)
00010e00	128KB starting at 0e000000  (SRAM at ae000000)
00001fbf        64KB starting at 1fbf0000
00001e00        64KB starting at 1e000000 (UART at be000000)
00001c00        64KB starting at 1c000000 (Ether at bc000000)
#endif

#if 0
// Serial ICE 

#define CPU_RXSTATUS_ASM  		0xbfff0200
#define CPU_RXSETUP_ASM   		0xbfff0200
#define CPU_RXDATA_ASM    		0xbfff0204
#define CPU_TXSTATUS_ASM  		0xbfff0208
#define CPU_TXDATA_ASM    		0xbfff020c

// Timer

#define CPU_TIMER0_INITIAL_COUNT_ASM       0xbfff0100
#define CPU_TIMER0_CURRENT_COUNT_ASM       0xbfff0104
#define CPU_TIMER1_INITIAL_COUNT_ASM       0xbfff0108
#define CPU_TIMER1_CURRENT_COUNT_ASM       0xbfff010c
#define CPU_TIMER_MODE_ASM	           0xbfff0110
#define CPU_INTERRUPT_STATUS_ASM	   0xbfff0114
#endif

#endif
