/*************************************************************
 * File: include/imon.h
 * Purpose: Header file for IMON
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	981222	Start of revision history
 *	981222	Added reg arg to ADDIU macro
 *	981222	Added macros for LUI, DSLL, ORI, LD
 */

#ifndef _IMON_H_
#define _IMON_H_

#include <mon.h>
#include <mips.h>

#define LR4001

#define DRIVER_BASE 	0x80020000	/* base address of driver area */

#define OP_ADDIU 0x24000000
#define OP_ORI	0x34000000
#define OP_LUI  0x3c000000
#define OP_LW   0x8c000000
#define OP_LHU  0x94000000
#define OP_LBU  0x90000000
#define OP_SW   0xac000000
#define OP_SH	0xa4000000
#define OP_SB	0xa0000000
#define OP_OR	0x00000025
#define OP_MTHI	 0x00000011
#define OP_MTLO  0x00000013
#define OP_MFHI  0x00000010
#define OP_MFLO  0x00000012
#define OP_MTC1	 0x44800000
#define OP_MFC1  0x44000000
#define OP_CFC1  0x44400000
#define OP_CTC1  0x44c00000

#define JALR_R4		0x0080f809
#define BLTZ(x,v)	(0x04000000|((x)<<21)|((v)&0xffff))
#define ADDIU(x,y,v)	(0x24000000|((x)<<16)|((y)<<21)|((v)&0xffff))
#define ORI(x,y,z)	(0x34000000|((x)<<16)|((y)<<21)|((z)&0xffff))
#define LUI(x,y)	(0x3c000000|((x)<<16)|((y)&0xffff))
#define DSLL(x,y,z)	(0x00000038|((x)<<11)|((y)<<16)|((z)<<6))
#define SUBIU(r,v)	(0x24000000|((r)<<21)|((r)<<16)|((0-v)&0xffff))
#define BNE(x,y,o)	(0x14000000|((x)<<21)|((y)<<16)|((o)&0xffff))
#define BEQ(x,y,o)	(0x10000000|((x)<<21)|((y)<<16)|((o)&0xffff))
#define MOVE(d,s)	(0x00000021|((d)<<11)|((s)<<21))
#define SW(r,o,a)	(0xac000000|((r)<<16)|((a)<<21)|((o)&0xffff))
#define SH(r,o,a)	(0xa4000000|((r)<<16)|((a)<<21)|((o)&0xffff))
#define LW(r,o,a)	(0x8c000000|((r)<<16)|((a)<<21)|((o)&0xffff))
#define LD(r,o,a)	(0xdc000000|((r)<<16)|((a)<<21)|((o)&0xffff))
#define SB(r,o,a)	(0xa0000000|((r)<<16)|((a)<<21)|((o)&0xffff))
#define SLLV(r,a)	(0x00000000|((r)<<16)|((r)<<11)|(((a)&0x1f)<<6))
#define MTC0(s,d)	(0x40800000|((s)<<16)|((d)<<11))
#define MFC0(s,d)	(0x40000000|((s)<<16)|((d)<<11))
#define MFD(d,s)	(0x7C000000|((d)<<16)|((s)<<11))
#define MTD(s,d)	(0x78000000|((d)<<11)|((s)<<21))

#if 0 /* this is where the info came from */
  0x0:  0080f809        jalr    ra,a0
  0x4:  ad220000        sw      v0,0(t1)
  0x8:  a1220000        sb      v0,0(t1)
  0xc:  1500fffd        bne     t0,zero,0x4
  0x10: 25290001        addiu   t1,t1,1
  0x14: 25290004        addiu   t1,t1,4
  0x18: 1500fffc        bne     t0,zero,0xc
  0x1c: 2508ffff        addiu   t0,t0,-1
  0x20: 0140f821        move    ra,t2
  0x24: 03e05021        move    t2,ra

  0x0:  8d3a0000        lw      k0,0(t1)
  0x4:  00000000        nop
  0x8:  001ad6c0        sll     k0,k0,27
  0xc:  07400002        bltz    k0,0x18
  0x10: 00000000        nop
  0x14: ad200000        sw      zero,0(t1)
  0x18: 25290010        addiu   t1,t1,16
  0x1c: 1509fff8        bne     t0,t1,0
  0x20: 7009020b        op1c    t1,zero,523
#endif

#define DVRIF_VERS	2

#ifdef LANGUAGE_C
/* you must change DVRIF_VERS if you change this struct */
typedef struct DriverTbl {
	Ulong entry_vector[2];
	int version;
	int *cputype;
	char *name;
	} DriverTbl;
#endif



#define SENDA0		0x12345678
#define RUN_MODE	0x87654321
#define SENDSAP		0xDEADBEEF
#define ATTN		0x55
#define ACK		0xaa

#ifdef NEW_KERNEL
/* old format stuff */
#define ICE_A0  0       /* a0 is used to hold the value to be sent */
#define ICE_A1  1       /* a1 is used as a temp */
#define ICE_V0  2       /* v0 is used to hold the value received */
#define ICE_T0  3       /* t0 is used by the host as a temp */
#define ICE_T1  4       /* t1 is used by the host as a temp */
#define ICE_T2  5       /* t2 is used by the host as a temp */
#define ICE_RA  6       /* ra is needed for bal/jal instrs */
#define ICE_OLD_EPC     7       /* saved so that it can be set */
#define ICE_S0  8
#define ICE_OLD_GWP 9   /* pointer to get_word routine */
#define ICE_OLD_PWP 10  /* pointer to put_word routine */
#define ICE_OLD_IBS 11  /* instruction buffer size */
#define ICE_OLD_SIZE 12

/* new format header */
#define ICE_SAV 0       /* save area version */
#define ICE_SAH 1       /* save area header size */
#define ICE_MAP 2       /* bit-map for savearea */
#define ICE_IBS 3       /* size of instr buffer */
#define ICE_GWP 4       /* pointer to get_word routine */
#define ICE_PWP 5       /* pointer to put_word routine */
#define ICE_EPC 6       /* saved so that it can be set */
#define ICE_LE  7       /* target endian 0=be 1=le */
/* end of header. The remainder is kernel-specific */

#else 
#define ICE_A0	0	/* a0 is used to hold the value to be sent */
#define ICE_A1	1	/* a1 is used as a temp */
#define ICE_V0	2	/* v0 is used to hold the value received */
#define ICE_T0	3	/* t0 is used by the host as a temp */
#define ICE_T1	4	/* t1 is used by the host as a temp */
#define ICE_T2	5	/* t2 is used by the host as a temp */
#define ICE_RA	6	/* ra is needed for bal/jal instrs */
#define ICE_EPC	7	/* saved so that it can be set */
#define ICE_S0  8
#define ICE_GWP 9	/* pointer to get_word routine */
#define ICE_PWP 10	/* pointer to put_word routine */
#define ICE_IBS 11	/* instruction buffer size */
#ifdef K0_IN_SAVEAREA
#define ICE_K0  12
#define ICE_SIZE 13
#else
#define ICE_SIZE 12
#endif
#endif


#ifdef LANGUAGE_C
extern int ice_baud;
#endif

#endif /*  _IMON_H_ */
