/*************************************************************
 * File: include/ether.h
 * Purpose: Definitions for Ethernet
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970325	Start of revision history
 *	970509	Added arphdr
 *	970617	Added icmp struct
 */

#ifndef _ETHER_H_
#define _ETHER_H_


/*
 * This file was extracted from several files in the /usr/include/netinet
 * directory, that carry the following copyright message.
 */

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 */
#ifdef BSO_TASKING
#define PACKED _pack
#endif

#ifndef PACKED
#define PACKED
#endif

#include <utypes.h>

/*
 * Ethernet address - 6 octets
 */
PACKED struct ether_addr {
        Uchar  ether_addr_octet[6];
	};
 
/*
 * Structure of a 10Mb/s Ethernet header.
 */
PACKED struct  ether_header {
        struct  ether_addr ether_dhost;
        struct  ether_addr ether_shost;
        Ushort ether_type;
	};  /* 14 bytes */
 
#define ETHERTYPE_PUP           0x0200          /* PUP protocol */
#define ETHERTYPE_IP            0x0800          /* IP protocol */
#define ETHERTYPE_ARP           0x0806          /* Addr resolution protocol */
#define ETHERTYPE_REVARP        0x8035          /* Reverse ARP */

/*
 * Internet address
 */
struct in_addr {
	Ulong s_addr;
	};

struct ip {
        Uchar  ip_vhl;                 /* version & header length */
#define getIP_V(x)      ((x)>>4) 
#define getIP_HL(x)     ((x)&0xf)
        Uchar  ip_tos;                 /* type of service */
        short  ip_len;                 /* total length */
        Ushort ip_id;                  /* identification */
        short  ip_off;                 /* fragment offset field */
#define IP_DF 0x4000                    /* dont fragment flag */
#define IP_MF 0x2000                    /* more fragments flag */
        Uchar  ip_ttl;                 /* time to live */
        Uchar  ip_p;                   /* protocol */
        Ushort ip_sum;                 /* checksum */
        struct in_addr ip_src,ip_dst;  /* source and dest address */
}; /* 20 bytes */

/* ip protocols */
#define IP_IP   0
#define IP_ICMP 1
#define IP_IGMP 2
#define IP_GGP  3
#define IP_TCP  6
#define IP_PUP  12
#define IP_UDP  17

/*
 * Udp protocol header.  From /usr/include/netinet/udp.h
 */

struct udphdr {
	Ushort	uh_sport;		/* source port */
	Ushort	uh_dport;		/* destination port */
	short	uh_ulen;		/* udp length */
	Ushort	uh_sum;			/* udp checksum */
	Ushort  uh_type;		/* added by pjb */
	Ushort	uh_seqno;		/* added by pjb */
	};

/* uh_type values */
#define UDP_RRQ		1
#define UDP_WRQ		2
#define UDP_DATA	3
#define UDP_ACK		4
#define UDP_ERROR	5	

#define UDP_TTL 0x3c

PACKED struct  arphdr { /* size=28 */
        Ushort ar_hrd;         /* format of hardware address */
#define ARPHRD_ETHER    1       /* ethernet hardware address */
        Ushort ar_pro;         /* format of protocol address */
        Uchar  ar_hln;         /* length of hardware address */
        Uchar  ar_pln;         /* length of protocol address */
        Ushort ar_op;          /* one of: */
#define ARPOP_REQUEST   1       /* request to resolve address */
#define ARPOP_REPLY     2       /* response to previous request */
#define REVARP_REQUEST  3       /* Reverse ARP request */
#define REVARP_REPLY    4       /* Reverse ARP reply */
        /*
         * The remaining fields are variable in size,
         * according to the sizes above, and are defined
         * as appropriate for specific hardware/protocol
         * combinations.  (E.g., see <netinet/if_ether.h>.)
         */
/* pjb: These sizes are only correct for TCP/IP over ethernet */
        Uchar  ar_sha[6];       /* sender hardware address */
        Uchar  ar_spa[4];       /* sender protocol address */
        Uchar  ar_tha[6];       /* target hardware address */
        Uchar  ar_tpa[4];       /* target protocol address */
	};

/*
 * Structure of an icmp header. (from netinet/ip_icmp.h)
 */
typedef Ulong n_time;
typedef Ushort n_short;
struct icmp {
        Uchar  icmp_type;              /* type of message, see below */
        Uchar  icmp_code;              /* type sub code */
        Ushort icmp_cksum;             /* ones complement cksum of struct */
        union {
                Uchar ih_pptr;                 /* ICMP_PARAMPROB */
                struct in_addr ih_gwaddr;       /* ICMP_REDIRECT */
                struct ih_idseq {
                        n_short icd_id;
                        n_short icd_seq;
                } ih_idseq;
                int ih_void;
        } icmp_hun;
#define icmp_pptr       icmp_hun.ih_pptr
#define icmp_gwaddr     icmp_hun.ih_gwaddr
#define icmp_id         icmp_hun.ih_idseq.icd_id
#define icmp_seq        icmp_hun.ih_idseq.icd_seq
#define icmp_void       icmp_hun.ih_void
        union {
                struct id_ts {
                        n_time its_otime;
                        n_time its_rtime;
                        n_time its_ttime;
                } id_ts;
                struct id_ip  {
                        struct ip idi_ip;
                        /* options and then 64 bits of data */
                } id_ip;
                Ulong  id_mask;
                char    id_data[1];
        } icmp_dun;
#define icmp_otime      icmp_dun.id_ts.its_otime
#define icmp_rtime      icmp_dun.id_ts.its_rtime
#define icmp_ttime      icmp_dun.id_ts.its_ttime
#define icmp_ip         icmp_dun.id_ip.idi_ip
#define icmp_mask       icmp_dun.id_mask
#define icmp_data       icmp_dun.id_data
};

#define ICMP_ECHOREPLY          0               /* echo reply */
#define ICMP_ECHO               8               /* echo service */

#define ETHER_INIT			0
#define ETHER_GETRBA		1
#define ETHER_RXDONE		2
#define ETHER_GETRXREC		3
#define ETHER_GETTBA		4
#define ETHER_TBARDY		5
#define ETHER_RXRDY			6
#define	ETHER_CLOSE			7	

typedef int *RXREC;	/* fake decl */
void *ether_driver(int op,void *vp1,void *vp2);

#endif /* _ETHER_H_ */
