/* ernicore.h
 * 	Definitions for the Ernie core
 */

#ifndef _ERNIE_CORE_
#define _ERNIE_CORE_
#define ERNIE_CORE
#include "cobrcore.h"

#define	M_BIU		0xfffe0130

#ifdef LANGUAGE_C
#define BIU		(*((volatile unsigned long *)M_BIU))

#define	C0_TAR		6		/* target address register */
#define	C0_BDAM		9		/* breakpoint data addr mask */
#define	C0_BPCM		11		/* breakpoint instr addr mask */
#else
#define	C0_TAR		$6		/* target address register */
#define	C0_BDAM		$9		/* breakpoint data addr mask */
#define	C0_BPCM		$11		/* breakpoint instr addr mask */
#endif

	/* cause register */
#define	CAUSE_BT	(1<<30)		/* branch taken */

	/* BIU */
#define	BIU_NOSTR	(1<<17)
#define	BIU_LDSCH	(1<<16)
#define	BIU_BGNT	(1<<15)
#define	BIU_NOPAD	(1<<14)
#define	BIU_RDPRI	(1<<13)
#define	BIU_INTP	(1<<12)
#define	BIU_IS1		(1<<11)
#define	BIU_IS0		(1<<10)
#define	BIU_IBLKSZMASK	(3<<8)
#define	BIU_IBLKSZSHFT	8
#define	BIU_IBLKSZ2	(0<<BIU_IBLKSZSHFT)
#define	BIU_IBLKSZ4	(1<<BIU_IBLKSZSHFT)
#define	BIU_IBLKSZ8	(2<<BIU_IBLKSZSHFT)
#define	BIU_IBLKSZ16	(3<<BIU_IBLKSZSHFT)
#define	BIU_DS		(1<<7)
#define	BIU_DS1		(1<<7)
#define	BIU_DS0		(1<<6)
#define	BIU_DBLKSZMASK	(3<<4)
#define	BIU_DBLKSZSHFT	4
#define	BIU_DBLKSZ2	(0<<BIU_DBLKSZSHFT)
#define	BIU_DBLKSZ4	(1<<BIU_DBLKSZSHFT)
#define	BIU_DBLKSZ8	(2<<BIU_DBLKSZSHFT)
#define	BIU_DBLKSZ16	(3<<BIU_DBLKSZSHFT)
#define	BIU_RAM		(1<<3)
#define	BIU_TAG		(1<<2)
#define	BIU_INV		(1<<1)
#define	BIU_LOCK 	(1<<0)

#endif /* _ERNIE_CORE_ */
