/*************************************************************
 * File: bsps/tstapp.c
 * Purpose: An example application for execution with SerialIce
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	981012	Created
 */

/*
 * This is an example application program for use with a SerialIce BSP.
 * It illustrates many of the features provided by the BSP.
 */

#include <stdio.h>	/* required for stdin */
#include <time.h>	/* required for time() */
#include <termio.h>	/* required for ioctl() */
#include <setjmp.h>	/* required for setjmp() */

char qbf[] = "The quick brown fox jumps over the lazy dog";

char *helpmsg[] = {
	"Commands:",
	"   clock", 		/* display the updating time */
	"   date [yymmddhhmm]", /* display/set the date/time */
	"   echo string...", 	/* print the string to the screen */
	"   help",
	"   sleep [secs]", 	/* sleep for a specified number of seconds */
	"   tx [lines]", 	/* print a specified number of lines of qbf[] */
	"   tftp", 		/* display the records received via tftp */
	0};

/*************************************************************
*/
main()
{
char buf[MAXLN],*av[MAXLN];
jmp_buf intrbuf;
int ac;

printf("Test application running...\n");
printf("Type 'help' for on-line help.\n");

/* Support ^C for kill. Only call ioctl the first time. */
if (setjmp(intrbuf) != 1) ioctl(STDIN,SETINTR,intrbuf);
else printf("break!\n");

for (;;) {
	printf("> ");
	fgets(buf,MAXLN,stdin);
	ac = argvize(av,buf);
	if (ac == 0) continue;
        if (strequ(av[0],"date")) {
                int mon,day,hr,min,yr;
		time_t tm;

                if (ac == 1) {
			tm = time(0L);
			printf("%s",ctime(&tm));
			}
                else if (sscanf(av[1],"%02d%02d%02d%02d%02d",
                                &yr,&mon,&day,&hr,&min)==5) {
                        tm = mktime(yr,mon,day,hr,min);
                        stime(&tm);
                        }
                else printf("usage: date [yymmddhhmm]\n");
                }
        else if (strequ(av[0],"echo")) {
		int i;

		for (i=1;i<ac;i++) printf("%s ",av[i]);
		printf("\n");
		}
        else if (strequ(av[0],"tx")) {
		int i,lines;

		if (!(ac == 2 && sscanf(av[1],"%d",&lines) == 1)) lines = 10;
		for (i=0;i<lines;i++) printf("%s\n",qbf);
		}
        else if (strequ(av[0],"clock")) {
		time_t n,t;
		char *timestr;
		int i;

		for (n=0,i=0;;i++) {
			t = time(0L);
			if (i > 1000) {
				/* ioctl FIONREAD returns the number of
				 * waiting characters.
				 */
				ioctl(0,FIONREAD,&i);
				if (i != 0) break;
				}
			if (t != n) {
				n = t;
				timestr = ctime(&t);
				timestr[24] = 0; /* delete the nl */
				printf("\r%s ",timestr);
				}
			}
		}
        else if (strequ(av[0],"sleep")) {
		int secs;

		if (!(ac == 2 && sscanf(av[1],"%d",&secs) == 1)) secs = 10;
		printf("sleep %d secs\n",secs);
		secs += time(0L)+1;
		while (time(0L) < secs) ;
		}
        else if (strequ(av[0],"tftp")) {
		int n,fd;

		fd = open("ethernet",0);
		if (fd == -1) {
			printf("unable to open ethernet.\n");
			continue;
			}
		printf("Waiting for tftp packets. Type ^C to quit.\n");
		for (;;) {
			n = read(fd,buf,MAXLN);
			buf[n] = 0;
			printf("%s",buf);
			}
		}
        else if (strequ(av[0],"help")) {
		int i;

		for (i=0;helpmsg[i];i++) printf("%s\n",helpmsg[i]);
		}
	else printf("%s: Command not found.\n",av[0]);
	}
}


