/*************************************************************
* tisr.s
*	Part of the program onintr.c. 
*	This example increments the variable 'ticks' each time
*	a timer interrupt occurs. The variable 'seconds' is
*	incremented after 100 'ticks'.
*	
*/
#include <mips.h>

#if defined(BDMR4101) || defined(BDMR4011)
#ifdef MIPSEB
#define M_S2681_BASE 0xbe000003
#else
#define M_S2681_BASE 0xbe000000
#endif
#endif

	.extern seconds,4		# permit GP relative addressing
	.comm ticks,4

/*************************************************************
*  tmrisr()
*	The exception handler for onintr.c
*/
	.globl tmrisr
	.ent tmrisr
        .set noat
tmrisr:
        .set noreorder
        mfc0    k0,C0_CAUSE
        nop
        .set reorder

#if defined(BDMR4101) || defined(BDMR4011)
        /* check if it's an int0 */
        sll     k0,(31-10)	# test bit 10 (IP3,int0)
        bltz    k0,1f   	# branch if bit set
#endif

#ifdef BDMR4102
        /* check if it's an int3 */
        sll     k0,(31-13)	# test bit 13 (IP5,int3)
        bltz    k0,1f   	# branch if bit set
#endif

	# call the next handler in the chain
	la      k0,tmrdat
        lw      k0,(k0)
        lw      k0,4(k0)
        j       k0

1:	#########################################################
	#							#
	/*	Body of user's ISR				*/

	#   k0 is the only register you can use without
	#   saving it first. So save t0 and t1
	subu	sp,8
	sw	t0,0(sp)
	sw	t1,4(sp)

	# acknowledge the interrupt
#if defined(BDMR4101) || defined(BDMR4011)
	li	k0,M_S2681_BASE+0x3c
	lbu	zero,(k0)
#endif

#ifdef BDMR4102
	li	k0,M_TMR4001+O_TSTAT
	lw	t0,(k0)
	li	t1,~TSTAT_IN1
	and	t0,t1
	sw	t0,(k0)
#endif

	# increase the tick/time count
	lw	k0,ticks
	addu	k0,1
	li	t0,100
	bne	t0,k0,1f

	lw	k0,seconds
	addiu	k0,1
	sw	k0,seconds
	li	k0,0

1: 	sw	k0,ticks

	# restore regs
	lw	t1,4(sp)
	lw	t0,0(sp)
	addu	sp,8

	#							#
	#########################################################

	# return to the interrupted program
        .set noreorder
        mfc0    k0,C0_EPC
        nop
        j       k0
        rfe
        .set reorder
        .set at
	.end tmrisr

