

#include <string.h>
#include <ctype.h>
#include <flashconfig.h>

#define FLASH_CONFIG_ADDRESS ((unsigned char *)0xbfc00020)

char	buf[256];
char	memarea[200];

main()
{
	unsigned long		crc;
	int					i;
	int					j;
	int					numether;
	unsigned long		MACaddress, oldMACaddress;
	flashConfigPtr		*flashConfig, *oldFlashConfig;
	char				*bptr, *bbptr;
	char				*ptr;

	oldFlashConfig = validateFlashConfig(FLASH_CONFIG_ADDRESS);
	if (oldFlashConfig != NULL)
	{
		printf("Using existing flash values as defaults.\n");
	}
	flashConfig = (flashConfigPtr *) memarea;
	bptr = bbptr = (char *) &flashConfig[1];

	do
	{
		do
		{
			printf("\nPlease enter number of ethernet interfaces:");
			
			gets(buf);
			
			numether = atoi(buf);
			
			if (numether <= 0 || numether > 3)
			{
				printf("\nBad number of ethernet interfaces %s\n", buf);
				numether = 0;
			}
			
		} while (numether == 0);
		
		do
		{
			printf("\nPlease enter last 6 hex digits of first MAC address");
			oldMACaddress = 0;
			if (oldFlashConfig != NULL)
			{
				flashConfigLength	valuelength;
				flashConfigValue	*valuep;

				if (getFlashConfigValue(oldFlashConfig, FLASHCONFIG_ETHERMAC0, &valuep, &valuelength) == 0)
				{
					oldMACaddress = valuep[3];
					oldMACaddress = (oldMACaddress << 8) + valuep[4];
					oldMACaddress = (oldMACaddress << 8) + valuep[5];
					printf(" (%06x)", oldMACaddress);
				}
			}
			printf(":");
			
			gets(buf);
			if (strlen(buf) != 0)
			{
				if (sscanf(buf, "%x", &MACaddress) != 1 ||
					(MACaddress & 0xff000000) != 0)
					MACaddress = 0;
			}
			else
			{
				MACaddress = oldMACaddress;
			}
			
			if (MACaddress == 0)
				printf("\nBad last 6 hex digits of first MAC address %s\n", 
					   buf);
			
		} while (MACaddress == 0);
		
		printf("\nnumber of ethernet interfaces: %d\n", numether);
		
		printf("first ethernet MAC address: %02x:%02x:%02x:%02x:%02x:%02x\n",
			   0x00, 0x02, 0xd8, 
			   (MACaddress >> 16) & 0xff,
			   (MACaddress >> 8) & 0xff,
			   MACaddress & 0xff);

		printf("If the above is correct, type 'y':");

		gets(buf);

	} while (buf[0] != 'y' && buf[0] != 'Y');

	for (i = 0; i < numether; i++)
	{
		*bptr++ = FLASHCONFIG_ETHERMAC0+i;
		*bptr++ = 6;
		*bptr++ = 0x00;
		*bptr++ = 0x02;
		*bptr++ = 0xd8;
		*bptr++ = (MACaddress >> 16) & 0xff;
		*bptr++ = (MACaddress >> 8) & 0xff;
		*bptr++ = MACaddress & 0xff;
		MACaddress++;
	}

	flashConfig->length = (signed short)(bptr - bbptr);
	flashConfig->offset = (signed short)(sizeof(flashConfigPtr));

	crc = crc32_payload_begin((unsigned char *) flashConfig,
							  sizeof(signed short) + sizeof(signed short));

	crc = crc32_payload_end(crc, (unsigned char *) bbptr, bptr - bbptr);

	flashConfig->crc = crc;

#if 0
	for (i = 0; i < bptr - memarea; i++)
		if ((i != 0 && (i % 8) == 0) || (i + 1) == (bptr - memarea))
			printf("%02x\n", memarea[i]);
		else
			printf("%02x ", memarea[i]);
#endif
	sprintf(buf, "copy -f -F %08x 0xbfc00020 %x",
			(unsigned int) &memarea[0],
			bptr - memarea);
	printf("Executing command: %s\n", buf);
	do_cmd(buf);
/*	printf("Want to replace pmon script at location 0xbfc70000\n"); */
}
