# File: examples/files.mk
# Purpose: List of example files
# Author: Phil Bunce (pjb@carmel.com)
# Revision History:
#	990114	Created

# GRP1 programs will run in any environment
GRP1 =  acker.c bubble.c dhry.c dry1.c fibo.c game.c hello.c \
	ledflash.c manufinfo puzzle.c qsort.c queens.c sieve.c sort.c \
	timetst.c irq.c tstapp.c mspethpolltest.c

# GRP2 programs will only run under PMON
GRP2 = onintr.c hanoi.c clock.c

# GRP1T Are GRP1 programs that require transcendental functions
GRP1T = whets.c whetd.c

# GRP2T Are GRP2 programs that require transcendental functions
GRP2T = sinewave.c wiggle.c

# Programs that require transcendental functions, eg. sin(x), have 
# not been included in the standard build list.  However, if your
# configuration includes support for transcendental functions you 
# may add these groups to the appropriate lists below by switching
# around the comment characters.

CFILES = $(GRP1) $(GRP2) $(GRP1T) $(GRP2T)
PMONLST = $(GRP1) $(GRP2)
#PMONLST = $(GRP1) $(GRP2) $(GRP1T) $(GRP2T)
ROMLST = $(GRP1)
#ROMLST = $(GRP1) $(GRP1T)
XLST = $(ROMLST) pmon
CLEANLST = $(XLST) $(GRP2)

ASFILES = tisr.s

OTHERS = Makefile pmon.mk stand.mk rom.mk xpmon.mk xstand.mk crules.mk \
	recrules.mk files.mk README

