LIBD = $(LSIPKG)/$(FPEM_DIR)/$(EDIR)
FLIB = -L$(LIBD)
SLIB = -lxc
LDFLAGS1 = -N -M -T ../pmon-examples.lk -nostdlib $(FLIB) -o $@ $(LIBD)/crt0x.o
LDFLAGS2 = $(SLIB)
LDFLAGS = $(LDFLAGS1) $+ $(LDFLAGS2)

onintr : onintr.o tisr.o
	$(LD) $(LDFLAGS) > $@.map
onintr.o : ../onintr.c ../tisr.s
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../onintr.c
tisr.o : ../tisr.s
	$(CC) -c $(ASFLAGS) -o $@ $(OPTS) ../tisr.s

irq : irq.o 
	$(LD) $(LDFLAGS) > $@.map
irq.o : ../irq.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../irq.c

acker : acker.o 
	$(LD) $(LDFLAGS) > $@.map
acker.o : ../acker.c 
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../acker.c

bubble : bubble.o 
	$(LD) $(LDFLAGS) > $@.map
bubble.o : ../bubble.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../bubble.c

dhry : dhry.o 
	$(LD) $(LDFLAGS) > $@.map
dhry.o : ../dhry.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../dhry.c

dry1 : dry1.o 
	$(LD) $(LDFLAGS) > $@.map
dry1.o : ../dry1.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) -O4 -G 10404 ../dry1.c

fibo : fibo.o 
	$(LD) $(LDFLAGS) > $@.map
fibo.o : ../fibo.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../fibo.c

game : game.o 
	$(LD) $(LDFLAGS) > $@.map
game.o : ../game.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../game.c

hanoi : hanoi.o 
	$(LD) $(LDFLAGS) > $@.map
hanoi.o : ../hanoi.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../hanoi.c

hello : hello.o 
	$(LD) $(LDFLAGS) > $@.map
hello.o : ../hello.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../hello.c

ledflash : ledflash.o 
	$(LD) $(LDFLAGS) > $@.map
ledflash.o : ../ledflash.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../ledflash.c

manufinfo : manufinfo.o 
	$(LD) $(LDFLAGS) > $@.map
manufinfo.o : ../manufinfo.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../manufinfo.c

puzzle : puzzle.o 
	$(LD) $(LDFLAGS) > $@.map
puzzle.o : ../puzzle.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../puzzle.c

qsort : qsort.o 
	$(LD) $(LDFLAGS) > $@.map
qsort.o : ../qsort.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../qsort.c

queens : queens.o 
	$(LD) $(LDFLAGS) > $@.map
queens.o : ../queens.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../queens.c

sieve : sieve.o 
	$(LD) $(LDFLAGS) > $@.map
sieve.o : ../sieve.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../sieve.c

sort : sort.o 
	$(LD) $(LDFLAGS) > $@.map
sort.o : ../sort.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../sort.c

stanford : stanford.o 
	$(LD) $(LDFLAGS) > $@.map
stanford.o : ../stanford.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../stanford.c

timetst : timetst.o 
	$(LD) $(LDFLAGS) > $@.map
timetst.o : ../timetst.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../timetst.c

tstapp : tstapp.o 
	$(LD) $(LDFLAGS) > $@.map
tstapp.o : ../tstapp.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../tstapp.c

whets : whets.o 
	$(LD) $(LDFLAGS) > $@.map
whets.o : ../whets.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) -O4 -G 4104 ../whets.c -lm

whetd : whetd.o 
	$(LD) $(LDFLAGS) > $@.map
whetd.o : ../whetd.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) -O4 -G 4104 ../whetd.c -lm

sinewave : sinewave.o 
	$(LD) $(LDFLAGS) > $@.map
sinewave.o : ../sinewave.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../sinewave.c -lm

wiggle : wiggle.o 
	$(LD) $(LDFLAGS) > $@.map
wiggle.o : ../wiggle.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../wiggle.c -lm

clock : clock.o 
	$(LD) $(LDFLAGS) > $@.map
clock.o : ../clock.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../clock.c

mspethpolltest : mspethpolltest.o 
	$(LD) $(LDFLAGS) > $@.map
mspethpolltest.o : ../mspethpolltest.c
	$(CC) -c $(CFLAGS) -o $@ $(OPTS) ../mspethpolltest.c
