/*************************************************************
 * File: bsps/printd.c
 * Purpose: diagnostics printer
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	980310	Created
 *	980506	Changed logfile to serialice1.log
 *	981204	Really changed logfile to serialice1.log
 */

#include <varargs.h>
#include <stdio.h>
#include <malloc.h>
#include "iceif.h"

#define LOGFILE "serialice1.log"

extern char vers[];

FILE *diagfp; /* diagnostics file pointer */
int diaglevel;

int vfprintf(FILE *fp,char *fmt,va_list ap);
int vsprintf(char *dst,char *fmt,va_list ap);
void printMsg(char *msg);

/*************************************************************
*/
void printDiag(level,fmt,va_alist)
int level;
char *fmt;
va_dcl
{
va_list ap;
char tmp[200];

if (diaglevel < level) return;

#ifdef PMCC
if (!diagfp) diagfp = stdout;
#else
if (!diagfp) {
	diagfp = fopen(LOGFILE,"w");
	if (!diagfp) return;
	}
#endif

#ifdef PMCC
if (level == 0) fprintf(diagfp,"ERROR: ");
va_start(ap);
vfprintf(diagfp,fmt,ap);
va_end(ap);
fflush(diagfp);
#else
if (level == 0) {
	va_start(ap);
	vsprintf(tmp,fmt,ap);
	va_end(ap);
	printMsg(tmp);
	}
else {
	va_start(ap);
	vfprintf(diagfp,fmt,ap);
	va_end(ap);
	fflush(diagfp);
	}
#endif
}

/*************************************************************
*/
void diagCntrl(char *str)
{
int n,level;
char devname[100];

if (diagfp && diagfp != stdout) fclose(diagfp);
diagfp = 0;
n = sscanf(str,"%d:%s",&level,devname);
diaglevel = level;

switch (n) {
        case 1 : /* verbose level only */
		if (level == 0) return;
#ifdef PMCC
                diagfp = stdout;
#else
		diagfp = fopen(LOGFILE,"w");
#if  0 /* defined(EJTAG) causes a crash */
		if (!EjtagControl(EJTAG_DIAG,diaglevel,diagfp)) {
			printDiag(0,"EjtagControl: DIAG: failed.\n");
			}
#endif
#endif
                break;
        case 2 : /* verbose level + device name */
                diagfp = fopen(devname,"w");
                if (diagfp) break;
                printDiag(0,"can't open %s\n",devname);
                break;
        default:
                printDiag(0,"diagCntrl: %s: bad value\n",str);
        }
printDiag(1,"version: %s\n",vers);
}

#ifdef PMCC
/* vfprintf calls free. We don't have an IMON entry for free. So I stub it */
/* vfprintf will only call malloc and free if the string is > 99 chars */
void free(void *adr){}
#endif

