/*************************************************************
 * File: bsps/imon.c
 * Purpose: IMON part of serialice interface
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	980310	Created
 */
#include <fcntl.h>
#include "iceif.h"

#define TMODE_RUN  1
#define TMODE_STEP 2
#define TMODE_SRUN 3
#define TMODE_DC   4
#define TMODE_DS   5
char *tmodes[] = {"none","run","step","srun","dc","ds"};

int trace_count;
int trace_mode;
int ice_port;

#include "defs.h"

/*************************************************************
*  run_target(mode,flags,count)
*	run_target(0,flags,clientcmd)	  -- go
*	run_target(1,0)		          -- continue
*	run_target(2,flags,count)         -- sstep
*/
void run_target(mode,flags,count) 
int mode,flags,count;
{
int i,type,wasbda;
Uchar ch;
Ulong cause,epc;
char prnbuf[100];

#if 0
printf("run_target(%d,%d,%d)\n",mode,flags,count);
#endif

if (!ice_port) iceInit();
switch (mode) {
   case 0 :
#if 0
	cmdstr = (char *)count;
	ac = argvize(client_av,cmdstr);
	putGpr(4,ac);
	putGpr(5,client_av);
	if (!(flags&1)) putGpr(29,clienttos());
#endif
	/* fall thru */
   case 1 :
	trace_mode = TMODE_RUN;
	if (force_getsap) { /* 980706 */
	        deleteOcmRec((Ulong)savearea.sap);
	        savearea.sap = 0;
		}
	break;
   case 2 :
	trace_mode = TMODE_STEP;
	trace_count = count;
	break;
   case 3 : /* gdb continue */
	trace_mode = TMODE_DC;
	break;
   case 4 : /* gdb sstep */
	trace_mode = TMODE_DS;
	trace_count = count;
	break;
   	}

wasbda = 0;
epc = getPc();
for (;;) {
	nobrkRemove = 1;
	if (trace_mode == TMODE_STEP || trace_mode == TMODE_DS ||
  	   (trace_mode == TMODE_RUN && (is_bpt(epc) || wasbda))) {
		if (trace_mode == TMODE_RUN) trace_mode = TMODE_SRUN;
		if (setTrcbp(epc,flags&T_O)) brkInstall(2);  /* TRACE */
		else {
			printf("Unable to set breakpoint(s) needed ");
			printf("for this operation.\n");
			printf("Please delete some breakpoints and ");
			printf("try again.\n");
			return;
			}
		}
	else brkInstall(1); /* REG+TEMP */

	send_buffer(); /* 970310 */
	/* 960226 */
	flush_target(ICACHE);
	flush_target(DCACHE);

	/* in verbose mode, disassemble as we go */
	if (flags&T_V && trace_mode == TMODE_STEP) {
		disasm(prnbuf,epc,read_target(XT_MEM,epc,4));
		printf("%s\n",prnbuf);
		}

	printDiag(1,"\nRUN MODE..");
	send_instr(RUN_MODE);
	target_stopped = 0;
	wasbda = 0;
	current_r8 = current_r9 = 0;
	nobrkRemove = 0;
	if (flags&T_W) return;
        for (;;) {
                read(ice_port,&ch,1); /* can ^C out of here */
                if (ch == ACK) break;
                printf("%02x ",ch);
                }
	target_stopped = 1;
	printDiag(1,"stopped\n");
	nobrkRemove = 1;
	/* if (force_getsap) resync(); */
	epc = getPc();
	cause = read_target(XT_CP0,C0_CAUSE,0);
	nobrkRemove = 0;
        type = brkRemove(epc);

	if (is_xvwmode() && type != BPTYPE_TRACE && type != BPTYPE_ITMP) {
		/* This exact string is expected by xvw - do not edit! */
		printf("!503!undefined breakpoint at %08x\n",epc);
		brkDelete(3); /* itemp */
		stop(0);
		}
	else if (trace_mode == TMODE_DC) gdbstop(1);
	else if (trace_mode == TMODE_DS) gdbstop(2);
	else if (type == BPTYPE_PC && getBpid() != -1) {
		brkDelete(3); /* itemp */
		stop(0);
		}
	else if (trace_mode == TMODE_STEP) {
		if (trace_count && --trace_count == 0) stop(0);
		}
	else if (trace_mode == TMODE_SRUN) trace_mode = TMODE_RUN;
	else if (type == BPTYPE_ITMP) {
		brkDelete(3); /* itemp */
		stop(0);
		}
	else if ((cause&CAUSE_EXCMASK) == EXC_DBE) { /* bda bpt */
		if (getBpid() != -1) stop(0);
		wasbda = 1;
		}
	else if ((cause&CAUSE_EXCMASK) == EXC_IBE) { /* bpc bpt */
		if (getBpid() != -1) stop(0);
		}
	else if (is_bpt(epc)) ;
	else if ((cause&CAUSE_EXCMASK) != EXC_BP) {
		printf("Exception! CAUSE=%08x (%s)\n",
			cause,excodes[(cause&CAUSE_EXCMASK)>>2]);
		brkDelete(3); /* itemp */
		stop(0);
		}
	else {
		printf("%08x: unknown breakpoint\n",epc);
		brkDelete(3); /* itemp */
		stop(0);
		}
	}
}



/*************************************************************
*/
Optdesc sync_opts[] = {
	{"","resync the comm link"},
	{0}};

sync_cmd(ac,av)
int ac;
char *av[];
{
target_stopped = 0;
resync();
if (force_getsap && !checkSAP()) {
	savearea.sap = 0;
	getSAP();
	}
printf("SAP=%08x\n",savearea.sap);
}

/*************************************************************
*/
Optdesc tx_opts[] = {
	{"bytes..","transmit bytes"},
	{0}};

tx_cmd(ac,av)
int ac;
char *av[];
{
int n,i;
Uchar ch;

i = 0;
for (i++;i<ac;i++) {
	atob(&n,av[i],16);
	ch = n;
	PUT_BYTES(&ch,1);
	}
}

/*************************************************************
*/
Optdesc rx_opts[] = {
	{"","receive bytes"},
	{0}};

rx_cmd(ac,av)
int ac;
char *av[];
{
int n;
Uchar ch;

for (n=0;;n++) {
	if (!GET_BYTE(&ch,1)) break;
	printf("%02x ",ch);
	}
if (n) printf("\n");
else printf("0 bytes waiting\n");
}

/*************************************************************
*/
Optdesc tstate_opts[] = {
	{"[running|stopped]","target state"},
	{0}};

tstate_cmd(ac,av)
int ac;
char *av[];
{
if (ac == 1) {
	printf("target state=%s\n",(target_stopped)?"stopped":"running");
	return;
	}
if (strequ(av[1],"stopped")) target_stopped = 1;
else if (strequ(av[1],"running")) target_stopped = 0;
else printf("%s: bad switch\n",av[1]);
}

/*************************************************************
*/
do_verbose(name,value)
char *name,*value;
{

if (strequ(value,"on")) diagCntrl("1");
else if (strequ(value,"off")) diagCntrl("0");
else if (isdigit(*value)) diagCntrl(value);
else printf("%s: bad value\n",value);
}


CmdRec icecmds[] = {
	{"sync",sync_opts,sync_cmd},
	{"tx",tx_opts,tx_cmd},
	{"rx",rx_opts,rx_cmd},
	{"tstate",tstate_opts,tstate_cmd},
	{0}};

int do_verbose();
EnvRec envlist[] = {
	{"verbose","off","off on N",do_verbose},
	{0}};

addicecmds()
{
int i;

for (i=0;icecmds[i].name;i++) addCmdRec(&icecmds[i]);
for (i=0;envlist[i].name;i++) addEnvRec(&envlist[i]);
}

/*************************************************************
*  void iceInit()
*/
void iceInit()
{
struct termio tbuf;

ice_port = open(ice_device,O_RDWR);
if (ice_port == -1) {
	printf("can't open %s\n",ice_device);
	ice_port = 0; /* 971216 */
	return;
	}
if (ioctl(ice_port,TCGETA,&tbuf) == -1) {
	printf("ioctl TCGETA failure\n");
	return;
	}
tbuf.c_lflag &= ~(ECHO|ICANON|ECHOE);
tbuf.c_iflag &= ~(ICRNL|ISTRIP|IXON);
tbuf.c_cflag &= ~CBAUD;
tbuf.c_cflag |= ice_baud;
tbuf.c_oflag &= ~(ONLCR);
if (ioctl(ice_port,TCSETAW,&tbuf) == -1) {
	printf("ioctl TCSETAF failure\n");
	return;
	}
}

void PUT_BYTES(Uchar *buf,int len) 
{
int i;

for (i=0;i<len;i++) printDiag(3,"%02x ",buf[i]);
printDiag(3,"\n");
if (!ice_port) iceInit();
write(ice_port,buf,len);
}

int GET_BYTE(Uchar *buf, int timeout)
{
int i,j,n;

if (!ice_port) iceInit();
for (i=j=0;;) {
	ioctl(ice_port,FIONREAD,&n);
	if (n) break;
	if (slow_target) {
		i++;
		if ((i%100000)==0) {
			printDiag(3,".");
			j++;
			}
		}
	else j++;
	if (j > timeout) return(0);
	}
read(ice_port,buf,1);
printDiag(3,"%02x ",*buf);
return(1);
}
