/*************************************************************
 * File: iceif.h
 * Purpose: Header file for SerialICE interface
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970310	Created from stuff extracted from iceif.c
 *	980707	Added readonly and map to OcmRec.
 *	980720	Added nobrkRemove.
 *	990121	Added BLOCK & SPEED.
 *	990331	Added FILL.
 */

#ifndef _ICEIF_H_
#define _ICEIF_H_

#define EJTAG	      /* enable ejtag support */

#define EJTAG_INIT   0 /* info=x argp=x      -- Init the ejtag subsystem */
#define EJTAG_RUN    1 /* info=x argp=x      -- Run the application */
#define EJTAG_CHECK  2 /* info=x argp=x      -- Check the target status */
#define EJTAG_STOP   3 /* info=x argp=x      -- Stop the target */
#define EJTAG_WRITE  4 /* info=v argp=x      -- append v to instr buffer */
#define EJTAG_EXE    5 /* info=x argp=vp     -- run instr buffer a0 to *vp */
#define EJTAG_WORD   6 /* info=v argp=x      -- download v to memory */
#define EJTAG_SAP    7 /* info=x argp=vp     -- Get SAP from target */
#define EJTAG_WAKEUP 8 /* info=x argp=x      -- wakeup target */
#define EJTAG_DIAG   9 /* info=v argp=vp     -- send diagfp to ejtag dll */
#define EJTAG_HWIB  10 /* info=x argp=vp     -- set hw instr bpt */
#define EJTAG_HWDB  11 /* info=x argp=vp     -- set hw data bpt */
#define EJTAG_CBPTS 12 /* info=x argp=x      -- clear all hw bpts */
#define EJTAG_BLOCK 13 /* info=x argp=vp     -- download block */
#define EJTAG_PORT  14 /* info=v argp=x      -- set port */
#define EJTAG_SPEED 15 /* info=v argp=x      -- set speed */
#define EJTAG_ENDIAN 16 /* info=x argp=vp    -- get endianness 1=be 0=le */
#define EJTAG_FILL 22  /* info=v argp=x      -- fill via dma */

#define SDBBP_CODE	0x7000003f
#define TINY_SDBBP_CODE	0xe801

#define NEW_KERNEL
#ifdef PMCC
#include <termio.h>
#endif
#include "mips.h"
#include "imon.h"
#include "utypes.h"

typedef int Bool;

extern BrkList brkList[MAX_BPT];
extern int cache_line_size;
extern int iflush_needed;
extern int icache_size;
extern Ulong flush_needed_addr;

extern char *ice_device;
extern int dflush_needed;
extern int dcache_size;

extern int dbx_needs_pa;
extern int need_initial_flush;
extern int has_ilock;
extern int has_nhwib;
extern int has_nhwdb;
extern int has_wb_dcache;
extern int instr_buffer_cnt;
extern int dcache_dirty;
extern int v1ibs;
extern Ulong v1regmap;
extern int nobrkRemove;
extern int diaglevel;
extern int undoc1;
extern int ejtag_mode;

extern int _cputype;

extern int force_getsap;
extern Ulong current_r8,current_r9;
extern int target_stopped;
extern int lendian_target;
extern int lendian_host;
extern int slow_target;
extern int send_ack_each_word;
extern int no_gpr30;
extern Ulong breakcode;
extern int kernel_ibs;
extern Ulong kernel_map;
extern int resyncOk;
extern int noforcek1;

#define brkInstall(t)	(* brkInstall_ptr)(t)
#define ilockReq(a)	(* ilockReq_ptr)(a)
#define flush_target(m)	(* flush_target_ptr)(m)
#define brkRemove(a)	(* brkRemove_ptr)(a)
#define setFlushneeded(a,n) (* setFlushneeded_ptr)(a,n)

extern vFunc *brkInstall_ptr;
extern Func *ilockReq_ptr;
extern vFunc *flush_target_ptr;
extern Func *brkRemove_ptr;
extern vFunc *setFlushneeded_ptr;

void brkInstall_400x();
int ilockReq_400x();
void flush_target_400x();
void flush_target_400x_ejtag();
int brkRemove_400x();
void setFlushneeded_400x();
void setFlushneeded_ejtag();
void init_4101(void);
void init_4102(void);

void brkInstall_401x();
int ilockReq_401x();
void flush_target_401x();
int brkRemove_401x();
void setFlushneeded_401x();
void init_4011(void);

void printDiag() ;

/* info about the serialice kernel */
typedef struct SaveArea {
	Ulong vers; 	/* header version 1=old 2=new */
	Ulong hsize; 	/* header size */
	Ulong map; 	/* regmap */
	Ulong ibs; 	/* instr buffer size */
	Ulong gwp;	/* addr of getword routine */
	Ulong *sap;	/* base address of savearea */
	Ulong le;	/* target endian 0=be 1=le */
	} SaveArea;
	
extern SaveArea savearea;
#endif
