#ifndef _DEFS_H_
#define _DEFS_H_

#include "iceif.h"

int serialice_ctrl(int mode,int arg2,int arg3,int arg4) ;
void iceInit(void) ;
int wakeup(void) ;
int readWord(Ulong *vp) ;
void swap32n(Uchar *p,int n) ;
void flushInput(void) ;
void getSAP(void) ;
Ulong readA0(void) ;
int send_instr(Ulong v) ;
void write_target(int type,Ulong addr,Ulong v,int sz);
int writeGpr(int reg,Ulong v) ;
Ulong read_target(int type,Ulong addr,int sz);
void run_target(int mode,int flags,int count) ;
void stop_target(void);
int check_target(void);
void virtualio(Uchar ch)  ;
void rxbyte(Uchar ch) ;
void send_vio_bytes(char *buf,int len) ;
void send_vio_byte(Uchar ch) ;
int setbp_target(int n,int type,Ulong addr,Ulong addr2,Ulong value) ;
int clrbp_target(int n) ;
int which_bpt(Ulong addr,int type) ;
int which_dbpt(int hwbptno) ;
int is_bpt(Ulong addr) ;
void brkDelete(Ulong type) ;
int is_writeable_target(Ulong adr) ;
void send_buffer(void) ;
void write_target_byte(Ulong addr,Ulong v) ;
void send_byte(Ulong addr,Uchar v) ;
void set_bytes(Ulong addr,Uchar v,int n) ;
void send_word(Ulong addr,Ulong v) ;
void send_bhw(Ulong addr,Ulong v,int sz) ;
void send_words(Ulong addr,Ulong *vp,int n) ;
int is_bptReq(Ulong addr,Ulong v) ;
void printDiag() ;
int disasm(char *prnbuf,Ulong epc,Ulong instr) ;
int setTrcbp(Ulong adr,int stepover) ;
int bytes_waiting(void) ;
void write_to_serial_port(Uchar ch) ;
void write_to_parallel_port(Uchar ch) ;
void PUT_BYTES(Uchar *buf,int len) ;
int GET_BYTE(Uchar *buf, int timeout) ;
void stop(int type) ;
int getBpid(void) ;
int is_gdbmode(void) ;
int is_xvwmode(void) ;
void gdbstop(int type) ;
Ulong get16Gpr(int n) ;
Ulong mips16_branch_target_address(Ulong adr,Ulong inst) ;
int mips16_needs_shift(Ulong inst) ;
Ulong mips16_actual_branch_target_address(Ulong adr,Ulong inst) ;
int mips16_is_extended(Ulong inst) ;
int mips16_is_jal(Ulong addr,Ulong inst) ;
int mips16_is_jr(Ulong addr,Ulong inst) ;
int mips16_is_branch(Ulong addr,Ulong inst) ;
int mips16_is_conditional_branch(Ulong addr,Ulong inst) ;
Ulong mXpc(int mode,int reg,int size,Ulong value) ;
Ulong mXgpr( int mode,int reg,int size, Ulong value) ;
Ulong mXmem( int mode,Ulong adr,int size, Ulong value) ;
Ulong mXc0( int mode,int reg,int size, Ulong value) ;
Ulong mXc1( int mode,int reg,int size, Ulong value) ;
Ulong cXc1( int mode,int reg,int size, Ulong value) ;
Ulong mXc2(int mode,int reg,int size, Ulong value) ;
Ulong cXc2(int mode,int reg,int size, Ulong value) ;
Ulong mXdbx(int mode,int reg,int size, Ulong value) ;
/*
int hwibReq(Ulong addr) ;
int hwdbReq(Ulong addr) ;
int ilockReq(Ulong addr) ;
void flush_target(int mode) ;
void brkInstall(int type) ;
int brkRemove(Ulong epc) ;
void setFlushneeded(Ulong addr) ;
*/
int is_branch(Ulong addr,Ulong inst) ;
int is_branch_likely(Ulong inst) ;
int is_conditional_branch(Ulong addr,Ulong inst) ;
int is_jr(Ulong addr,Ulong inst) ;
int is_jal(Ulong addr,Ulong inst) ;
Ulong branch_target_address(Ulong adr,Ulong inst) ;
void simm(char *dest) ;
Ulong actual_branch_target_address(Ulong adr,Ulong inst) ;
int instr_size(Ulong adr,Ulong inst) ;
void bcopy(Uchar *s,Uchar *d,int n) ;
void OpenCommPort(int mode,int port,int baud);
void WriteCommPort(char *buf,int len);
int ReadCommPort(char *buf, int timeout);
void CloseCommPort(void);
int params_in_file(void);
void init_4101(void);
void init_4102(void);
void init_4011(void);
OcmRec *is_ocm(Ulong addr);
void printBpts(void);
OcmRec *addOcmRec(Ulong addr,Ulong size,Ulong *func,int funclen);
void ocm_cmd(int ac,char *av[]);
Ulong run_ocm(OcmRec *ocm,int mode,Ulong addr,int sz,Ulong value);
Ulong readUgpr(int reg);
void writeUgpr(int reg,Ulong v);
int is_cacheable(Ulong addr);
int resync(void);
void diagCntrl(char *str);
void chomp(char *str);
int argvize(char *av[],char *src);
Ulong dis16(char *prnbuf,Ulong addr,Ulong instr);
char *strccat(char *dst,char c);
int checkSAP(void);
int deleteOcmRec(Ulong addr);
Ulong readCache_400x(int set,int what,Ulong addr);
Ulong readCache_401x(int set,int what,Ulong addr);
Ulong domt1(Ulong sadr,Ulong eadr);
void domt2(Ulong sadr,Ulong eadr);
Ulong domt3(Ulong sadr,Ulong eadr);
void setilockbpt_400x(Ulong addr,Ulong bptcode,int sz);
void clrilockbpt_400x(Ulong addr);

int EjtagControl(int op,Ulong info,void *argp);
int EjtagDownload(Ulong addr,int words);
void init_4102(void);
void brkInstall_ejtag(int type);
int brkRemove_ejtag(Ulong epc);

void printMsg(char *msg);
int sload(char *fname);



#endif
