/*************************************************************
 * File: d4001.c
 * Purpose: SerialICE driver for LSI 4001
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970208	Start of revision history
 *	970829	Fixed CPC0EN..CPC3EN
 *	970829	Fixed offset for LO reg
 *	980226	Removed ilockReq,hwdbReq,hwibReq. Now in 400x.
 *	980312	Switched to unified scheme for dll and imon.
 *	990203	Fixed LO and HI (33 & 32) was reversed.
 */

#ifndef LR4001
#define LR4001
#endif
#include "iceif.h"

char _drivername[] = "Driver for LR4001";

#define LCK_BIT 	(1<<4)


/*************************************************************
*  r4001dvr.c
*	This file contains all the register definitions used
*	by the 'r' (display regs) command. There are two types
*	of definitions: RegList that defines all the registers, 
*	and RegSpec's that define the bit fields within a register.
*/

static RegSpec Cfgreg4001[] = {
        {1,31,"TLBEN",2,0,0},
        {1,30,"WBEN",2,0,0},
        {1,29,"DSNOOP",2,0,0},
        {1,28,"ISNOOP",2,0,0},
        {1,24,"FBE",2,0,0},
        {1,19,"CPC3EN",2,0,0},
        {1,18,"CPC2EN",2,0,0},
        {1,17,"CPC1EN",2,0,0},
        {1,16,"CPC0EN",2,0,0},
        {1,13,"DBERR",2,0,0},
        {3,10,"PGSZ",10,0,0},
        {2,8,"CMODE",10,0,0},
        {1,7,"RDPRI",2,0,0},
        {2,5,"DSIZE",10,0,0},
        {1,4,"DCEN",2,0,0},
        {2,2,"ISIZE",10,0,0},
        {1,1,"IS1",2,0,0},
        {1,0,"ICEN",2,0,0},
        {0}}; 

static RegSpec DCSreg4001[] = {
        {1,31,"TR",2,0,0},
        {1,30,"UD",2,0,0},
        {1,29,"KD",2,0,0},
        {1,28,"TE",2,0,0},
        {1,27,"DW",2,0,0},
        {1,26,"DR",2,0,0},
        {1,25,"DAE",2,0,0},
        {1,24,"PCE",2,0,0},
        {1,23,"DE",2,0,0},
        {1,22,"IBD",2,0,0},
        {1,21,"EBE",2,0,0},
        {1,5,"T",2,0,0},
        {1,4,"W",2,0,0},
        {1,3,"R",2,0,0},
        {1,2,"DA",2,0,0},
        {1,1,"PC",2,0,0},
        {1,0,"DB",2,0,0},
        {0}};

static RegSpec Stat[] = {
	{4,28,"CU",2,0,0},
	{1,22,"BEV",2,0,0},
	{1,21,"TS",2,0,1},
	{1,20,"PE",2,0,1},
	{1,19,"CM",2,0,0},
	{1,18,"PZ",2,0,0},
	{1,17,"SWC",2,0,0},
	{1,16,"ISC",2,0,0},
	{8,8,"IM&SW",2,0,0},
	{1,5,"KUo",2,0,0},
	{1,4,"IEo",2,0,0},
	{1,3,"KUp",2,0,0},
	{1,2,"IEp",2,0,0},
	{1,1,"KUc",2,0,0},
	{1,0,"IEc",2,0,0},
	{0}};

static RegSpec Tmr4001Mode[] = {
        {1,10,"DOG1",2,0,0},
        {1,9,"PULSE1",2,0,0},
        {1,8,"EN1",2,0,0},
        {1,1,"PULSE0",2,0,0},
        {1,0,"EN0",2,0,0},
        {0}};

static RegSpec Tmr4001Stat[] = {
        {1,1,"INT0",2,0,0},
        {1,0,"IEN0",2,0,0},
        {0}};

static RegSpec Caus[] = {
	{1,31,"BD",2,0,1},
	{2,28,"CE",10,0,1},
	{6,10,"IP",2,0,1},
	{2,8,"SW",2,0,0},
	{4,2,"EXCODE",0,excodes,1},
	{0}};

static RegSpec PRid[] = {
	{8,8,"IMP",10,0,1},
	{8,0,"Rev",10,0,1},
	{0}};

static RegRec reglist[] = {
	{mXpc,0,"PC","pc",14,(F_MIPS|F_CPU)},
	{mXgpr,0,"LO","LO",33,(F_MIPS|F_CPU)},
	{mXgpr,0,"HI","HI",32,(F_MIPS|F_CPU)},
	{mXc0,Stat,"C0_SR","SR",12,(F_MIPS|F_CP0)},
	{mXc0,Caus,"C0_CAUSE","CAUSE",13,(F_MIPS|F_CP0)},
	{mXc0,PRid,"C0_PRID","PRID",15,(F_MIPS|F_CP0)},
	{mXc0,0,"C0_EPC","EPC",14,(F_MIPS|F_CP0)},
	{mXc0,0,"C0_BADVA","BADVA",8,(F_MIPS|F_CP0)},
        {mXmem,Cfgreg4001,"M_CFG4001","CFG",M_CFG4001,0},
        {mXmem,0,"M_TIC0","TIC0",O_TIC0,0},
        {mXmem,0,"M_TCC0","TCC0",O_TCC0,0},
        {mXmem,0,"M_TIC1","TIC1",O_TIC1,0},
        {mXmem,0,"M_TCC1","TCC1",O_TCC1,0},
        {mXmem,Tmr4001Mode,"M_TMODE","TMODE",M_TMR4001+O_TMODE,0},
        {mXmem,Tmr4001Stat,"M_TSTAT","TSTAT",M_TMR4001+O_TSTAT,0},
	{0}};

int cache_cmd_400x();
extern Optdesc cache_opts_400x[];

CmdRec cmdlist[] = {
	{"cache",cache_opts_400x,cache_cmd_400x},
	{0}};

/*************************************************************
*  dvrInit()
*/
dvrInit()
{
int i;

ice_baud = B38400;
ice_device = "/dev/tty1";
for (i=0;reglist[i].func;i++) addRegRec(&reglist[i]);
addicecmds();
for (i=0;cmdlist[i].name;i++) addCmdRec(&cmdlist[i]);
need_initial_flush = 1;
init_4001();
}

init_4001()
{
has_ilock = 1;
_cputype = 4001;
icache_size = 4*1024;
cache_line_size = 16;
}


