/*************************************************************
 * File: lib/vfprintf.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	980618	Removed fudge factor calc for fmt length. Now using vstrlen.
 */

#include "varargs.h"
#include "strfmt.h"
extern int vstrlen(char *s, va_list ap);
extern int vsprintf(char *d, char *s, va_list ap);
extern void serial_out(char *buf);

char errmsg[] = "vfprintf: out of memory\n\r";

/*************************************************************
*  int vfprintf(fmt,ap)
*/
int vfprintf(fmt,ap)
char *fmt;
va_list ap;
{
char buf[100];
int n;

n = vstrlen(fmt,ap);
if (n > 99) {
  serial_out(errmsg);
}
else {
  n = vsprintf(buf,fmt,ap);
  serial_out(buf);
}
return(n);
}


